DIGIFLAG(1)           XROUTER REFERENCE MANUAL               24/9/2023

COMMAND
        DIGIFLAG -- Display / Set digipeat options.

SYNOPSIS
        DIGIFLAG <port> [0-1023]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The DIGIFLAG command is used to display and/or set the 
        digipeat options for a specified port.

        New settings override those read from the XROUTER.CFG file,
        and remain in force until changed, or the system is restarted.

        The minimum abbreviation of this command is DIGIF.

OPTIONS
        Options are enabled by adding together the following numbers:

        Bit Value Option
        ---------------------------------------------------
         0    1   Digipeat UI frames
         1    2   Digipeat non-UI frames
         2    4   Enable RELAY generic digipeating (deprecated).
         3    8   Enable TRACE generic digipeating (deprecated).
         4   16   Enable WIDE generic digipeating (deprecated).
         5   32   Allow APRS 3rd party digi via L4.
         6   64   Allow digipeating to Internet (IGate).
         7  128   Allow digipeating from Internet (IGate).
         8  256   Enable UITRACE digipeating (e.g. WIDEn-n)
         9  512   Enable UIFLOOD digipeating (e.g. GBRn-n)

EXAMPLES
        DIGIF 3         Enquire current setting for port 3
        DIGIF 3 259     Enable UITRACE and normal digipeat on port 3
        DIGIF 2 0       Disable all digipeating on port 2

ADDITIONAL INFO
        UITRACE and UIFLOOD are two special addresses that are
        suffixed with pseudo-SSID's, e.g. "TRACE4-4" and "WIDE2-2".
        These addresses can digipeat several times. The first digit
        specifies the maximum number of hops, and the second is the
        hop counter, which is decremented each time the frame is
        digipeated.

        These two addresses behave slightly differently however. When
        a frame is digipeated on the address specified by UITRACE,
        each digipeater inserts its own callsign in the digipeater
        list and decrements the "SSID". Frames digipeated on the
        UIFLOOD address have their SSIDs decremented, but the digi
        doesn't insert its own callsign. 

        For the sake of consistency with UI-View, UITRACE defaults
        to "TRACE", giving TRACEn-n digipeating, and UIFLOOD
        defaults to WIDE, giving WIDEn-n digipeating.

        However, according to the APRS "New Paradigm", RELAY, TRACE
        and WIDE are deprecated, UITRACE should be set to "WIDE",
        and UIFLOOD should be set to a "state" code (e.g. "GBR" for
        the UK). These addressses may be specified in XROUTER.CFG.

        One of the main justifications for the new paradigm was the
        fact that some of the older digipeaters would repeat the same
        packets over and over. This does not happen with XRouter, due
        to its dupe prevention measures.

        Not everyone agrees with the "New Paradigm, so the choice of
        which features to enable is left you you.

SEE ALSO
        DIGIPORT(1)    -- Set port to digipeat on
        DIGIFLAG(7)    -- Digipeating Options.
        XROUTER.CFG(8) -- Main Configuration File.

DIGIFLAG(1)                      END OF DOCUMENT
