;*************************** Max Width *******************************
DISCARDPORT(7)         XROUTER REFERENCE MANUAL              24/9/2023

NAME
        DISCARDPORT -- TCP Port for DISCARD Server.

SYNPOSIS
        DISCARDPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        DISCARDPORT is an optional GLOBAL configuration directive
        used in XROUTER.CFG.

        If present, it specifies the TCP "service port" number for
        the DISCARD server. If not present, the default is 9.
 
        The DISCARD server is a "sink" session, whereby XRouter
        ignores (discards) everything sent to it.  This is a useful
        tool for testing connections, throughput etc.

OPTIONS
        If a single argument is supplied, e.g. "DISCARDPORT=99", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "DISCARDPORT=99 9999",
        the first argument applies to the XRouter stack and the
        second to the host system's stack. The numbers must be
        separated by whitespace

        Setting DISCARDPORT to zero on a stack prevents TCP
        connections to the server via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        DISC-SRV(9)    -- Discard Server.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

DISCARDPORT(7)           END OF DOCUMENT
