;***********************|****|* Max Width *|***|*********************|
DISTRIB.SYS(8)          XROUTER REFERENCE MANUAL             30/9/2025

NAME
        DISTRIB.SYS -- Mail Distribution File.

DESCRIPTION
        Optional file DISTRIB.SYS controls queuing of mail for
        delivery to neighbouring mailboxes.

        If present, it is located in XRouter's PMS subdirectory. If
        the file is absent, mail is not delivered to other mailboxes.

        The file is read "live" upon receipt of each item of
        "forwardable" mail, which means it can be edited on the fly,
        with modificatiions taking immediate effect.

FORMAT
        Lines must not exceed 127 characters. Comment lines are
        allowed. These must start with '#' or ';' in first column.

        DISTRIB.SYS contains "rules" for mail distribution. If there
        are no rules, there can be no mail forwarding

        Each "rule" consists of a minimum of 4 and a maximum of 5
        fields on a single line.  The fields, which may be separated
        by spaces or tabs, are as follows:

            <type>  <to>  <at>  <via>  [max_size]

        <type>  Message type (e.g. P, B or *)

        <to>    Message recipient or bulletin category (wildcards ok)
                If the <to> field starts with a caret '^', it REJECTS
                the message if it matches. e.g. "^EQUAKE" prevents
                distribution of EQUAKE messages.

        <at>    Distribution area, e.g. "GB7PZT", "EU" or "#24.GBR".
                If wildcards are NOT included, a "sliding match", is
                performed, e.g. EU matches EU and EURO, GBR matches
                .#76.GBR.EURO and so on.
                If wildcards ARE included, a "pattern match" is
                performed instead, so be careful to specify the full
                pattern.  A "*" by itself meana "match any".

        <via>   Callsign (minus SSID) of the neighbouring mailbox to
                which the item of mail should be sent.

        [max_size] is optional. If non-zero, it specifies the maximum
                   message size in bytes. Messages whose size exceeds
                   this value are not queued.

OPERATION
        Each new message is tested against the rules, looking for a
        matching rule. If <type> <to> and <at> all match the fields
        of the message, the latter is placed on the queue for the
        mailbox specified by <via>. The queue is later processed
        according to the rules in FWD.SYS.

        Rules are processed in the sequence in which they are
        declared. Therefore "reject" entries MUST be declared before
        "accept" entries.

        Private mail is queued for the FIRST match only.
        Bulletins are distributed to ALL matching entries.

EXAMPLE
        The organisation of this file is up to you, but the following
        method is recommended.

        Firstly, route any private mail addressed TO nearby sysops
        and users. This ensures delivery even if the hierarchical
        address is wrong:

            # <type> <to>    <at>    <via>   [max_size]
            # --------------------------------------------------
                P    VA2OM   *       VE2PKT
                P    VE2PKT  *       VE2PKT
                P    MW0NXT  *       GB7NXT

        Next, handle mail explicitly addressed AT neighbour BBS's.
        Again, this guards against incorrect hierarchical addresses.

            # <type> <to>    <at>    <via>   [max_size]
            # --------------------------------------------------
                *    *       VA2OM   VE2PKT
                *    *       VE2PKT  VE2PKT
                *    *       GB7NXT  GB7NXT

        Finally, handle bulletin distribution. In this case, all
        EQUAKE bulletins are ignored. All remaining bulls go to
        VE2PKT, but only GBR, EU and WW are sent to GB7NXT.

            # <type> <to>    <at>    <via>   [max_size]
            # --------------------------------------------------
                B    ^EQUAKE *       *
                B    *       *       VE2PKT
                B    *       GBR     GB7NXT
                B    *       EU      GB7NXT
                B    *       WW      GB7NXT  5000

SEE ALSO
        FWD.SYS(8) -- Mailbox Forwarding Control File
        PMS(9)     -- About the Mailbox.

DISTRIB.SYS(8)               END OF DOCUMENT
