DNS(1)                  XROUTER REFERENCE MANUAL            19/10/2023

COMMAND
        DNS -- Domain Name Server commands.

SYNOPSIS
        DNS {<A[dd] | D[rop]> <ipaddr>} | <C[ache]> | <L[ist>

DESCRIPTION
        The DNS commands are used to add and delete Domain Name 
        Servers from the DNS list, and to display the list or cache.

        Domain Name Servers are external TCP/IP hosts which are used 
        to resolve host names, for example "bbc.co.uk", into IP 
        addresses, when the information is not found locally in 
        DOMAIN.SYS.

        In order for XRouter to use this process, it needs to know
        the IP addresses of suitable DNS's.  These are usually
        specified in XROUTER.CFG.

        If no servers are specified, XRouter will use the domain
        resolution services provided by the operating system. 

        The "Split DNS" system used by XRouter allows private
        domains to be resolved using their own servers.

OPTIONS
        a) "DNS ADD <ipaddr> [domain]" adds the name server whose IP
           address is specified by <ipaddr> to the server list.

           The [domain] argument may be specified with or without a
           trailing dot.  e.g. ".ampr.org" or ".ampr.org.".

           If [domain] is specified, the name server will only be
           used to resolve hostnames in that domain, and the host
           names in that domain will only be resolved using that
           server and no others.

           For example: "DNS=44.131.91.245 .ampr.org." tells XRouter
           to exclusively use the server 44.131.91.245 to resolve all
           ampr.org hostnames.  That server will not be used to
           resolve hosts outside the ampr.org domain, and ampr.org
           will not be resolved using any other server.


        b) "DNS DROP <ipaddr>" deletes the nameserver specified by
           <ipaddr> from the server list.
 
        c) "DNS LIST" displays the list of domain name servers.

        d) "DNS CACHE" displays the contents of XRouter's domain
            cache.

EXAMPLES
        DNS ADD 44.131.91.245 .ampr.org.
        DNS ADD 62.31.117.22
        DNS DROP 44.131.88.73

FILES
        Domain servers are usually specified in XROUTER.CFG using
        one or more "DNS=<ipaddr> [domain]" directives.  Omit the
        directives to force the use of the operating system's DNS.

        Alternatively, the DNS ADD command may be used in
        BOOTCMDS.SYS. 

HISTORY
        This command, and the DNS server / client were necessary in
        DOS XRouter, but have less relevance in XRouter because the
        Operating System provides Domain Resolution services.

        However, the facilities were not deleted when the code was
        ported to XRouter, because it is conceivable that (a) someone
        might wish to use an external DNS via SLIP or PPP or RF
        because the OS has no Internet connection (Imagine a node
        on a remote site, with no internet connection), or (b) they
        may wish to act as a DNS for TCP/IP over radio.

NOTE
        If XRouter obtains its IP address via DHCP or PPP, it will 
        automatically obtain primary and secondary DNS addresses, and 
        remove them from the list when the lease terminates.

AVAILABILITY
        Sysop-only.

DNS(1)                      END OF DOCUMENT
