DOMAIN.SYS(8)           XROUTER REFERENCE MANUAL            17/10/2023

NAME
        DOMAIN.SYS -- Hostname Resolution File.

DESCRIPTION
        This optional file is used to "resolve" host names such as
        "g8jvm.ampr.org" and aliases such as "lgsbbs" into their
        corresponding IP addresses. 

        It is the first place XRouter looks when resolving a hostname.
        If the file is not present, or the hostname is not found in
        in the file, XRouter queries a DNS (Domain Name Server) to
        obtain the information (in order for this to work, either
        Windows/Linux or XRouter must have a network connection to an
        external DNS).

        If no DNS is available, and the hostname is not found in
        DOMAIN.SYS, you will have to enter the full IP address of
        the target host when using the PING, TELNET, TTY, and FINGER
        commands. 

        Name resolution using a radio-based DNS is quite slow, so if
        you are using this mode you should add entries to this file
        for frequently contacted hosts whose addresses are stable.
 
        Externally resolved names are added automatically to
        DOMAIN.SYS at regular intervals, and expired entries are
        purged.

FILE FORMAT
        Each host is listed on a separate line.  Each field must be
        separated by one or more spaces or tabs.  Comments, spaces,
        tabs and blank lines are permissible to aid clarity.  The
        records are case-insensitive, but most people use lower case
        for hostnames.  The format of each record is as follows:

             <hostname> [ttl] IN A <ip-address>

             <alias>    [ttl] IN CNAME <hostname>
             
             <hostname> [ttl] IN MX [pref] <hostname>

        The first form maps a hostname to an IP address, and the
        second and third forms map alternative hostnames to a host
        that is already defined.  

        For example, the IP address for the GB7PZT mailbox is
        44.131.91.2 so it would have an Internet Address (IN A)
        record like so:

             gb7pzt  IN   A    44.131.91.2

        But gb7pzt is also known locally as "pztbbs", and "kdrbbs". 
        There is nothing to stop you adding further "IN A" records
        for gb7pzt, one for each alias, but you could instead use
        the second form shown above, the CNAME or "Canonical Name"
        record like so:

             pztbbs. IN CNAME  gb7pzt
             kdrbbs. IN CNAME  gb7pzt

        Thus if the user types "TEL pztbbs" or "TEL kdrbbs", the
        gb7pzt record is used.  This removes the need to keep
        repeating the IP address in multiple "A" records, and makes
        it easier if the IP address is changed.

        The MX or "Mail Exchange" records are usually used for
        defining alternate names for mail servers, but as XRouter is
        not concerned with mail you can use them in the same way as
        CNAME entries, although there would be no point in doing so.
        The format of the additional records would be:

             pztbbs.   IN   MX   gb7pzt
             kdrbbs.   IN   MX   gb7pzt

        The optional "preference" field of MX records is ignored.
        
        The optional [ttl] field in all types of entry is the
        "time to live" of the entry in seconds, used to expire
        records whose addresses are liable to change.  If omitted or
        set to zero, the record has an unlimited lifetime. 

        In order to simplify the file, the ".ampr.org" is usually
        omitted from the records, and appended automatically when
        the file is read.  However, hostnames which contain or end
        with a dot will not be extended in this manner.  Thus
        "gb7pzt" would be extended to "gb7pzt.ampr.org", whereas
        "lgs." and "ns.cyberphile.co.uk" would not be modified.

NOTES
        Although DOMAIN.SYS was originally designed to be simpler
        than the more standard DOMAIN.TXT format, Xrouter is capable
        of understanding both formats, so you may use an existing
        DOMAIN.TXT simply by renaming it to DOMAIN.SYS.

FILES
        DOMAIN.SYS is located in the same directory as XRouter.EXE.

LIMITATIONS
        XRouter's DNS server currently responds only to type A
        queries.

SEE ALSO
        DNS(1) -- DNS Configuration Commands.

DOMAIN.SYS(8)                END OF DOCUMENT
