DUN(1)                  XROUTER REFERENCE MANUAL            16/10/2023

COMMAND
        DUN -- Dial Up Networking configuration commands.

SYNOPSIS
        DUN A[dd] <callsign | ip_address> <script>
        DUN D[rop] <callsign | ip_address>
        DUN L[ist]
        DUN LO[g] [0-255]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        Dial-Up Networking (DUN) is a subsystem which allows Xrouter 
        to connect to other TCP/IP systems via a dial-up Public 
        Switched Telephone Network (PSTN) link.  The DUN commands 
        are used to configure this subsystem.

OPTIONS
        DUN ADD creates an association between a callsign (for KISS 
        links) or gateway IP address (for PPP or SLIP links) and a DUN 
        script.

        DUN DROP removes a previously created association between a 
        callsign or gateway IP address and a DUN script.

        DUN LIST lists the peers to whom a dial-up connection may be 
        established, and the names of the scripts used to make the 
        connections.

        DUN LOG sets the level of logging, for diagnostic purposes.  
        The argument is a flag field, comprising the sum of the 
        following values:

            1        Log starts, stops and errors.
            2        Log all script lines.
            4        Log responses from modem or host.

        A value of 0 disables all logging.  If no arguments are 
        supplied, the current logging level is reported.

EXAMPLES
        DUN ADD gb7tyr  gb7tyr.scr
        DUN ADD 62.31.176.22  pipex.scr
        DUN DROP 62.31.176.22
        DUN LOG 3

FILES
        The DUN ADD and DUN LOG commands may also be used in 
        IPROUTE.SYS and / or BOOTCMDS.SYS to set up the system at boot 
        time.

SEE ALSO
        DIAL(1)   -- Dial a PSTN connection.
        SCRIPT(9) -- Dialler script commands.
        DUN(9)    -- Dial-Up Networking.

DUN(1)                       END OF DOCUMENT
