DX(1)                   XROUTER REFERENCE MANUAL              6/9/2023

COMMAND
        DX -- Displays distant APRS stations.

SYNOPSIS
        DX [ port | node [port] ]

AVAILABILITY
        All users.

DESCRIPTION
        The DX command displays a list of the most distant APRS
        stations heard by XRouter, along with their positions,
        distances and headings.

        Providing XRouter's position is defined (see below), APRS
        position reports heard by XRouter will be recorded in the
        DX list, in order of distance.

        The sysop may set this up (using the DXFLAGS keyword in 
        XROUTER.CFG) to show only the directly heard stations, or
        may choose to include those heard via digipeaters. He may
        also specify a minimum distance for table inclusion.

        If included, digipeated stations are clearly identifiable
        by an entry in the "Via" field, which is blank for directly
        heard stations.

OPTIONS
        When no argument is used, stations received on all ports are
        displayed.

        If an optional port number is supplied, only the stations
        received on that port will be shown

        if the first argument is the callsign or alias of a known
        node, the DX list of that node is requested, provided the
        target node is XRouter v502s or later. If the second argument
        is a port number, only the records for that port on the
        target node are requested

EXAMPLES
        DX           - Display all DX stations on this node
        DX 13        - Display DX from port 13 only.
        DX KIDDER    - Display all DX records on KIDDER node
        DX KIDDER 16 - Display DX records on KIDDER node's port 16

        G8PZT:KIDDER} Dx list:
        Prt Callsn Dist Dir  Date  Time Frm Position           Via
        9   GB7GH  62Km 170  22/08 10:59 72 5151.20N 00205.80W
        4   G6GUH  21Km 325  22/08 05:41  1 5233.38N 00225.80W
        1   G3KFD  13Km  36  21/08 17:38  5 5229.65N 00208.28W
        (End of list)

            Prt      - Port number
            Dist     - Distance in Kilometers
            Dir      - Heading in degrees
            Date     - Date & time of last reception
            Frm      - No. of frames seen
            Position - Latitude & longitude of station in APRS format
            Via      - Digipeater callsign (blank if heard direct)

FILES
        The DXFLAGS=n directive is used in XROUTER.CFG to control
        the DX list. The flags are made up as follows:

           1 - Record digipeated stations (defaults off).
           2 - Enable logging of DX exceeding specified distance.
           4 - Log frame contents of qualifying DX

        If logging is enabled Bits 3 - 14 specify the minimum
        distance which will be logged, from 4Km to 32764Km in 8Km
        steps, e.g. DXFLAGS=502 enables DX logging, with a threshold
        of 500Km. If logging is not enabled, bits 3-14 are ignored.

        If DX logging is enabled, any received APRS positions which
        exceed the threshold distance are logged to LOG/DXLOG.TXT.

        XRouter's position is defined in XROUTER.CFG, either by using
        LOCATOR (which gives a coarse position), or by including an
        APRS position string in the IDTEXT, for example:

        IDTEXT
        !5224.00N/00215.00W Kidderminster Router (KIDDER)
        ***

CAVEATS
        If XRouter's position has not been defined, no DX information
        will be available

SEE ALSO
        AMSG(1)    -- APRS messaging shell
        DXFLAGS(7) -- DX List Control Flags

DX(1)                    END OF DOCUMENT

