DXFLAGS(7)              XROUTER REFERENCE MANUAL              6/9/2023

NAME
        DXFLAGS -- DX List Control Flags.

SYNOPSIS
        DXFLAGS=n (where n is a decimal number)

DESCRIPTION
        The DXFLAGS directive is used in XROUTER.CFG to control
        the DX list. The flags are made up as follows:

           1 - Record digipeated stations (defaults off).
           2 - Enable logging of DX exceeding specified distance.
           4 - Log frame contents of qualifying DX

        If logging is enabled Bits 3 - 14 specify the minimum
        distance which will be logged, from 4Km to 32764Km in 8Km
        steps, e.g. DXFLAGS=502 enables DX logging, with a threshold
        of 500Km. If logging is not enabled, bits 3-14 are ignored.

        If DX logging is enabled, any received APRS positions which
        exceed the threshold distance are logged to LOG/DXLOG.TXT.

        XRouter's position is defined in XROUTER.CFG, either by using
        LOCATOR (which gives a coarse position), or using LATITUDE
        LONGITUDE, or by including an APRS position string in the
        IDTEXT, for example:

            IDTEXT
            !5224.00N/00215.00W Kidderminster Router (KIDDER)
            ***

CAVEATS
        If XRouter's position has not been defined, the program will
        not start.
        
SEE ALSO
        DX(1)          -- Show Distant Stations
        XROUTER.CFG(8) -- Main Configuration File.

DXFLAGS(7)                  END OF DOCUMENT
