DYNDNS(9)            XROUTER REFERENCE MANUAL                 6/9/2023

NAME
        DYNDNS -- Dynamic DNS Update Client.

DESCRIPTION
        More and more people these days have dynamic IP addresses,
        i.e. IP addresses which are assigned by their Internet Service
        Provider and which may be different each time they log on. 
        Broadband users are permanently connected to the internet, but
        even their IP addresses may be changed at any time by the ISP,
        unless they pay extra for a static address.

        For the normal internet user this is not a problem, because
        no-one else needs to know their IP address. However, if you
        want other people to be able to connect to your system, e.g.
        if you are running a web server, they need to know your
        current IP address. This is where the dynamic DNS providers
        come in.

        There are many organisations providing dynamic DNS services,
        one of whom is DYNDNS.ORG. It is easy, and free, to set up an
        account with dyndns.org, and after doing so you may choose one
        or more hostnames for your system, for example "g8pzt.ath.cx".

        All you then have to do is keep dyndns.org informed of your
        current IP address, either manually or using an automatic
        update client. Whenever someone asks their system to connect
        to "g8pzt.ath.cx", they are given its current IP address.

        Xrouter has an integral client for automatically maintaining
        dynamic DNS entries at dyndns.org, thus obviating the need to
        run an external client or perform manual updates.  If the
        client is enabled, and your IP address changes, the client
        will update one or more hostname entries on the dyndns.org
        DNS server.  If you do not use dynamic dns, you need read no
        further.

        The client is enabled by including the directive DYNDNS=1 in
        the relevant PORT configuration block in XROUTER.CFG, i.e. the
        port which is connected to the Internet. DYNDNS=0 disables the
        client, as does omitting the directive altogether.  Note: you
        must only use this directive on ONE port, and you may crash
        XRouter if you try to use it on more than one.

        The client requires a configuration file, DYNDNS.CFG, and it
        creates a data file DYNDNS.BIN. The configuration file is
        heavily commented, so it should be self-explanatory.

        If your Xrouter is *directly* connected to the Internet, i.e.
        via a PSTN modem or non-routing cable modem, the client simply
        monitors the port IP address (which is assigned by the ISP
        using IPCP or DHCP), and tells dyndns.org when it changes.
        This mode is selected by putting "NO" on the "Use external IP
        detection service" configuration line in DYNDNS.CFG.

        However, if your connection to the Internet is via a NAT
        router such as an ADSL modem/router or Windows ICS, the port
        IP address will be a "private" one which no-one else could
        access. In this case, the client can be configured to query an
        external IP address detection service at regular intervals,
        updating dyndns.org if a change is detected. This mode is
        selected by putting "YES" on the "Use external IP detection
        service" configuration line.

        Free accounts on dyndns.org are removed if they haven't been
        updated for 35 days.  Thus, if your IP address hasn't changed
        for 30 days, the client automatically sends an update to keep
        the account refreshed.

        You may have more than one hostname associated with your IP
        address, but that's not a problem.  In the "hostname(s) to be
        updated" line, simply list the hostname, separated by commas.
        Be careful not to include any spaces or mistakes in the line.

FILES
        DYNDNS.CFG(8) -- Configuration file

SEE ALSO
        DYNDNS(7)      -- Enable / Disable Dynamic DNS Update Client.
        XROUTER.CFG(8) -- Main Configuration File.

DYNDNS(9)                 END OF DOCUMENT
