ENCAP.TXT(8)            XROUTER REFERENCE MANUAL            17/10/2023

NAME
        ENCAP.TXT -- Amprnet Encapsulated Routing File (optional).

DESCRIPTION
        This is *not* an XRouter configuration file, but XRouter
        is capable of reading it.

        ENCAP.TXT is simply a text file which contains a huge list
        of amateur IP routes and the Internet addresses of IPEncap
        gateways which handle them.

        If this file is present when XRouter boots up, it will read
        the routes into its IP routing table.

        If you are not running an amprnet "gateway", or have set up
        your own encap routes in IPROUTE.SYS, you do not need this
        file.

FORMAT
        The format of routing entries in ENCAP.TXT is as follows:

           route addprivate 44.131.91.0/24 encap 62.31.206.176

        The "addprivate" stipulates that the route should be hidden
        from users, i.e. not displayed by the IPROUTES command.

        The "44.x.x.x/xx" part specifies which amprnet route(s)
        this entry applies to.

        The "encap" part tells XRouter to use IPEncap protocol,
        i.e. it is the same as using routing mode "e".

        The final field is the Internet IP address of the gateway
        which handles the specified amprnet route(s).

FILES
        If required. ENCAP.TXT should be located in same directory
        as the XRouter executable.

NOTES
        ENCAP.TXT is subject to frequent modification, so you will
        need to obtain updated copies from time to time, and use
        IP ROUTE LOAD (or restart XRouter) to load them. A batch
        file to obtain and edit the ENCAP.TXT can be run by the
        Windows / Linux task scheduler, and IP ROUTE LOAD can then
        be called afterwards by a suitable entry in CRONTAB.SYS.

CAVEATS
        On Windows, it is NOT possible to use "encap" protocol
        without using the NDISXPKT driver. Without the driver, XR32
        is forced to use the Windows IP stack, instead of its own,
        for accessing the Internet. The problem is, Windows no longer
        allow IPEncap to pass via it's IP stack. The protocol was
        blocked for "security reasons" when Microsoft issued XP
        service pack 2. It should work on Windows 2000 and early
        versions of XP however. There are no such restrictions on
        Linux.

        If you are a gateway, you must remove your own entry from
        ENCAP.TXT before loading it, otherwise catastrophic
        looping will occur (this may have been fixed in later
        versions).

        ENCAP.TXT contains over 500 entries, and may make your IP
        routing slower, because all those routes must be searched
        recursively for every single datagram routed by your
        system.  With a fast computer or low data rate you
        probably wouldn't notice the difference however.

BACKGROUND
        IPEncap (usually called "encap", but sometimes erroneously
        called IPIP) "encapsulates" amateur IP within the payload of
        public (Internet) IP datagrams. Thus it is sometimes called
        IP-over-IP or IP-within-IP, but should not be called "IPIP",
        because that is an older version of the protocol. Encap is
        assigned IP protocol number 4, and IPIP is protocol 94. 

        Encapsulation allows amateur IP (44.x.x.x addresses) to be
        "tunnelled" or "wormholed" across the internet, between
        amprnet gateways. In order to do this, each gateway needs to
        know the Internet addresses of the other gateways, and which
        amprnet datagrams shoule be sent to which gateway.  That
        information is located in ENCAP.TXT.

        In order to keep the amprnet secure, the gateway owners need
        to prevent their IP addresses from becoming public knowledge.
        Thus the contents of ENCAP.TXT are a closely guarded secret.
        The file is obtained from an FTP server whose address is
        known only to the gateway sysops.

SEE ALSO
        IPENCAP(9)     -- IP-within-IP Encapsulation.
        IPROUTE.SYS(8) -- IP Routing and Configuration File

ENCAP.TXT(8)                END OF DOCUMENT
