ENGLISH.SYS(8)          XROUTER REFERENCE MANUAL            22/10/2023

NAME
        ENGLISH.SYS -- English Language Texts for XRouter.

DESCRIPTION
        ENGLISH.SYS is an optional file containing English Language
        Texts which are used within XRouter.

        If present, the contents of this file are read at bootup
        only, replacing XRouter's inbuilt prompts, headings and
        responses.

        XRouter's inbuilt language is ENGLISH. If you wish, you may
        change the layout and/or wording of most XRouter responses by
        installing ENGLISH.SYS in the same directory as XRouter.
        XRouter will then use the texts from that file, which you may
        modify, instead of the inbuilt ones.

        Be careful with modifications, because some of the texts are
        used in multiple places, and some of them are column headers
        which need to follow a strict format. Installing and
        modifying this file is NOT recommended, but it's up to you!

        Modifications to this file do not affect other languages.

FORMAT
        Each text is on a separate line, which begins with a number
        corresponding to that text. Following the number is some 
        whitespace, then the text itself is enclosed in quotes.  For
        example:

            12  "Syntax error\r"

        Most texts end with "\r" (carriage return, ASCII 13), but not
        all of them do. "Hanging" prompts and individual words don't.

        Blank lines, and lines which begin with '#' in the leftmost
        column are ignored. The latter can be used for comments.

        Some texts contain one or more placeholders such as "%s",
        "%d" etc. You may move their position within a text, but if
        you change them, you will cause XRouter to crash.

        For example, you could safely re-word the following:

            73  "Session %d not found\r"

        to the following:

            73  "I'm sorry, I can't find session %d\r"

        "%d" is a placeholder for an integer
        "%s" is a placehlder for a string of characters

        Changes don't take effect unless XRouter is restarted.

        Text numbers fall into the following ranges:

            1-999 General texts
            1000  PZTDOS texts
            2000  AX25/NetRom texts
            3000  Chat server texts
            4000  APRS Messaging System Texts
            5000  FTP Client texts
            6000  PMS Texts
            7000  IDS (Intrusion Detection System) texts

        If a required text is not found in the file (e.g. it has
        been deleted or commented out), the inbuilt text is used
        instead.

SEE ALSO
        CONSOLELANG(7)  -- Console language.
        DEFAULTLANG(7)  -- Specify default language.
        DEUTSCHE.SYS(8) -- German Language Texts.
        ESPANOL.SYS(8)  -- Spanish Language Texts.
        FRANCAIS.SYS(8) -- French Language Texts.
        LANGS.SYS(8)    -- Language selection file.

ENGLISH.SYS(8)               END OF DOCUMENT
