;*************************** Max Width *******************************
EXCLUDE(7)            XROUTER REFERENCE MANUAL               24/9/2023

COMMAND
        EXCLUDE -- AX25 Blacklist.

SYNOPSIS
        EXCLUDE=<callsign>[,<callsign>...]

DESCRIPTION
        EXCLUDE is an optional directive used in XROUTER.CFG.

        It specifies a list of one or more callsigns from whom AX25
        frames are ignored, and is this the opposite of VALIDCALLS.

.       It would typically be used on a user-access port to prevent
        connections from trouble-makers, pirates or other nodes,
        e.g. for preventing CB nodes from interconnecting with ham
        radio nodes and vice versa.

        If used within the "global" section of XROUTER.CFG, the
        exclusion is "inherited" by any PORTs subsequently defined.

        If used within a PORT definition block, the exclusion applies
        to that port only.

        Multiple callsigns must be separated by commas, and the list
        must not include any spaces.

        Exclusions can be changed during run-time using the EXCLUDE
        command.

EXAMPLE
        EXCLUDE=NOCALL,P1RAT ; Ignore these users 

SEE ALSO
        EXCLUDE(1)     -- AX25 L2 exclusion command
        L3EXCLUDE(7)   -- NetRom Layer 3 exclusions
        PORTS(6)       -- Ports in XRouter.
        VALIDCALLS(7)  -- AX25 Whitelist.
        XROUTER.CFG(8) -- Main Configuration File.

EXCLUDE(7)                  END OF DOCUMENT
