;*************************** Max Width *******************************
EXCLUDE(1)             XROUTER REFERENCE MANUAL              20/9/2023

COMMAND
        EXCLUDE -- Prevent connections from a callsign.

SYNOPSIS
        EXC[lude] <port> [call[,call..] | clear | none]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The EXCLUDE command is used to manage AX25 level 2
        exclusions, i.e. callsigns that are blocked from connecting
        to the node using AX25.

        Exclusions can apply on a port-by-port basis, or globally.

        They can be added at boot-time using the EXCLUDE directive
        in XROUTER.CFG, or during run-time using the EXCLUDE command.

        The command can be used multiple times, to add one or more
        callsigns at a time. Callsigns are appended to the list, if
        they are not already in the list.


OPTIONS
        "EXC[lude] <port>" displays the exclusion list for <port>.

        If <port> is 0, the command applies globally, i.e. to all
        ports. To avoid confusion, global exclusions are not shown
        in port exclusion lists.

        "EXC[lude] <port> <callsign>" adds <callsign> to the list of
        stations prevented from connecting on <port>.

        Multiple callsigns may be added in this way, by adding them
        as a comma separated list, like so:

        "EXC[lude] <port> <callsign>,<callsign>,<callsign>..."

        "EXC[lude] <port> NONE" and  "EXC[clude] <port> CLEAR" can be
        used interchangeably, and they both clear the list.



        There is as yet no way to remove a single callsign, other
        than remove them all and reinstate the wanted ones. If anyone
        needs this, please request it.

EXAMPLES
        exclude 0 g9mtt                 Exclude G9MTT globally

        exclude 4                       Display list for port 4

        exclude 4 gd7dr                 Add GD7DR

        exclude 5 g8pzt,g2bof.fred      Add 3 calls

        exclude 5 none                  Delete all calls

        exclude 4 clear                 Delete all calls

    
SEE ALSO
        EXCLUDE(7)     -- AX25 L2 exclusion directive
        XROUTER.CFG(8) -- Main Configuration File.

EXCLUDE(1)                  END OF DOCUMENT
