;***********************|****|* Max Width *|***|*********************|
EXPORT.SYS(8)           XROUTER REFERENCE MANUAL             29/3/2024

NAME
        EXPORT.SYS -- Mail Export Control File.

DESCRIPTION
        The optional file EXPORT.SYS, which resides in the PMS
        subdirectory, controls "exporting" of messages to files.

        It is read "live" upon receipt of each new mesaage, so it can
        be edited on the fly, and any edits take effect immediately.

        Exporting can be used to archive selected messages, or to
        create files that can be imported into other mail systems.

FORMAT
        Comment lines are allowed. These must begin with a semicolon
        or hash in the first column.

        Lines beginning with '@' specify the filename to which
        messages are to be exported, and the file opening mode to use. 

        The mode is specified by a single (optional) character, which
        follows the filename, after a gap of one or more spaces:

          O = overwrite    A = Append (default)

        Overwrite mode would typically be used when only the most
        recent copy of a regular message, e.g. a weather report, was
        required

        For all other lines, the fields are:

            <format>  <type>  <to>  <from>  <at>  <mid>  <subject>

        <format> can be one or two characters. The first character
                 specifies the format of the exported message:
                 (F = as a file, M = MBL).

                 The optional second character determines routing
                 header (R: line) stripping:

                 H    = Include all routing header lines.
                 R    = Include first (originating) R: line only.
                 None = Don't include any R: lines

        <type>   specifies the type of message to be exported:

           B = Bulletin, P = Private, A = Ack, 7 = 7plus, * = Any

        The remaining fields specify which messages are to be
        exported, depending on any combination of TO, FROM, AT, MID
        or subject.

        All fields are case-independent, and wildcards are allowed.
        However, the <subject> field behaves slightly differently to
        the others. The supplied <subject>, which may contain more
        than one word, is tested against all parts of the message
        subject, in a "sliding match". For example "news" will match
        both "RSGB Main News" and "DX News". The only wildcard allowed
        in the subject field is a single "*" (match any subject)

EXAMPLES
        The following example exports TECH bulletins sent by G8MNY,
        to the file PMS/TECH.SAV in "append" mode, using "MBL" format,
        and omitting all R: lines except the one generated by the
        original sender's mailbox:

        @PMS/TECH.SAV
        # <format>  <type>  <to>  <from>  <at>  <mid>  <subject>
        #-------------------------------------------------------
           MR         B     TECH   G8MNY    *     *       *


        The next example appends retro computing bulletins to the
        file "retro.txt" in "MBL" mode, omitting all routing headers:

        @/home/pi/retro/retro.txt
        # <format>  <type>  <to>  <from>  <at>  <mid>  <subject>
        #-------------------------------------------------------
           MR         B     CBM      *      *     *       *
           MR         B     ATARI    *      *     *       *
           MR         B       *      *      *     *       VIC20


        The final example shows the use of "overwrite" mode, to store
        a copy of the latest DX News in the BBS files area as a file
        without any MBL headers or R: lines:

        @FILES/DXNEWS.TXT O
        # <format>  <type>  <to>  <from>  <at>  <mid>  <subject>
        #-------------------------------------------------------
           F          B     DXNEWS   *      *     *     Latest

SEE ALSO
        EXPORT(4) -- Export Message to File.
        IMPORT(4) -- Import Message(s) From File.
        PMS(9)    -- About the Mailbox.
        
EXPORT.SYS(8)                END OF DOCUMENT
