;***********************|****** Max Width *****|*********************|
EXTERN-IFACE(6)         XROUTER REFERENCE MANUAL             26/9/2023

NAME
        EXTERN-IFACE -- Interface Type "EXTERNAL". .

DESCRIPTION
        The EXTERNAL interface type is intended for interfacing with
        Ethernet, WiFi and other things yet to be decided.

        The name is a hang-over from XR16 (DOS), where an external
        TSR program managed the interface with the NIC packet driver.
        The external interface was also used to interface with BPQ-
        compatible drivers. XR32 (Windows) also used an external
        program, "NdisXpkt", to provide the Ethernet connection.

        XRPi / XRLin don't need an external driver for Ethernet, but
        rather than confuse existing XR sysops by introducing a new
        interface type, the same configuration was used.

        A typical Ethernet INTERFACE and PORT combination is shown
        below:

            INTERFACE=5
                ID=eth0
                TYPE=EXTERNAL
                PROTOCOL=ETHER
                MTU=1064
            ENDINTERFACE

            PORT=7
                ID=Ethernet Adaptor
                INTERFACENUM=5
                IPADDRESS=192.168.0.221
            ENDPORT

        The interface and port numbers are for example only.

        In the INTERFACE block, the ID directive specifies the device
        name, e.g. "eth0" for the first Ethernet adaptor or "wlan0"
        for wireless LAN adaptor. These names may vary from platform
        to platform, e.g. on MX-Linux the wireless lan adaptor might
        be named "eth1" not "wlan0".

        The PROTOCOL directive specifies the hardware layer protocol
        for the interface. At present only ETHER (Ethernet) protocol
        is used on this type of interface.

        In the PORT block, The ID directive specifies a human-readable
        brief description of the interface, e.g. "LAN Adaptor
        (192.168.0.221)".

        The IPADDRESS directive specifies the IP address to be used on
        this interface. This overrides XRouter's "core" IPADDRESS for
        this port only. It must be different to the Linux IP address,
        and must be appropriate for the local subnet.

CAVEATS
        If XRouter is run from an account with root priviliges, no
        special conditions apply, otherwise its access to resources
        is restricted by Linux's security policies.

        To use the EXTERNAL interface without root priviliges, the
        XRouter executable needs to be granted CAP_NET_RAW capability.
        See CAPFLAGS for more information.

SEE ALSO
        IFACES(6)      -- Interfaces.
        CAPFLAGS(6)    -- Capability Flags.
        PORTS(6)       -- Ports in XRouter.
        RUNROOT(6)     -- Run as Root or Not?
        XROUTER.CFG(8) -- Main Configuration File.

EXTERN-IFACE(6)             END OF DOCUMENT
