FEC(7)                XROUTER REFERENCE MANUAL               24/9/2023

NAME
        FEC -- Enable / disable Forward Error Correction.

SYNOPSIS
        FEC=<0|1>

DESCRIPTION
        FEC is an optional PORT configuration directive, used in
        XROUTER.CFG.

        It controls whether or not Reed-Solomon Forward Error
        Correction is enabled on that port.

        In order to make use of FEC, the port needs to be using a
        KISS TNC with the CRC check disabled (PASSALL ON), an SCC
        card or YAM modem. The default is 0, i.e. disabled. 

        Forward error correction is useful on links with high BER
        (bit-error-rates). Up to 8 erroneous bytes per frame may be
        automatically corrected, at the expense slightly larger
        frames. FEC is not required on links with very low BER.
        FEC is normally disabled by default, and is enabled by
        including the FEC=1 directive in the appropriate PORT
        configuration block in XROUTER.CFG. It can then be turned
        on and off at will from the command line.

        If FEC is used, the "allow L2 fragmentation" bit must be set
        in the port CFLAGS, to allow XRouter to fragment large L3
        frames which might otherwise exceed the reduced L2 Paclen.

CAVEATS
        Frames containing FEC look like garbage to "normal" AX25
        systems. Thus in order to use FEC on a link, BOTH ends of
        the link must be FEC-capable. Future versions may allow one
        way FEC.

        Stations who are not running FEC may interpret FEC-encoded
        frames incorrectly, leading either to a failure to decode
        or possibly to corrupt node broadcasts or inaccurate APRS
        positioning. Therefore FEC should not be used on a shared
        channel.

SEE ALSO
        FEC(1)         -- Control Forward Error Correction.
        CFLAGS(7)      -- Connection Control Flags.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

FEC(7)                  END OF DOCUMENT
