FEC(1)                  XROUTER REFERENCE MANUAL            17/10/2023

COMMAND
        FEC -- Control Forward Error Correction.

SYNOPSIS
        FEC <port> [0-255]

DESCRIPTION
        The FEC command allows you to display and set the Reed
        Solomon Forward Error Correction properties for a port.
        At present, the only property which can be controlled is
        FEC on/off.

        Forward error correction is useful on links with high BER
        (bit-error-rates). Up to 8 erroneous bytes per frame may be
        automatically corrected, at the expense slightly larger
        frames. FEC is not required on links with very low BER.

        In order to make use of FEC, the port needs to be using a
        KISS TNC with the CRC check disabled, or an SCC or YAM card.

OPTIONS
        The first argument is a port number, and is required. If not
        supplied, a syntax reminder is displayed.

        The second argument is optional. If supplied, the FEC flags
        for the specified port are set to the numeric value of the
        argument. If not supplied, the current value is reported.

        A zero value turns FEC off, and a non-zero value turns it on.

EXAMPLES
        FEC 1   - Display current FEC setting for port 1.
        FEC 1 0 - Turn off FEC on port 1

NOTES
        A suitable KISS ROM image for use with FEC is KISSFEC.BIN,
        which should be provided in the XRouter release package. Note
        that this ROM is for use only with XRouter, and only for FEC.

        The FEC flag may be changed in future to allow it to be
        enabled on TX, RX, both or neither.  This would allow one
        way FEC, e.g. for use in the case where a link is bad in one
        direction but good in another. Other flags may be used to
        control parameters such as interleaving.

FILES
        FEC is normally disabled by default, and is enabled by
        including the FEC=1 directive in the appropriate PORT
        configuration block in XROUTER.CFG. It can then be turned
        on and off at will from the command line.

        If FEC is used, the "allow L2 fragmentation" bit must be set
        in the port CFLAGS, to allow XRouter to fragment large Netrom
        L3 frames which might otherwise exceed the reduced L2 Paclen.

CAVEATS
        Frames containing FEC look like garbage to "normal" AX25
        systems. Thus in order to use FEC on a link, BOTH ends of
        the link must be FEC-capable.

        Stations who are not running FEC may interpret FEC-encoded
        frames incorrectly, leading either to a failure to decode
        or possibly to corrupt node broadcasts or inaccurate APRS
        positioning. Therefore FEC should not be used on a shared
        channel

AVAILABILITY
        Sysops-only.

SEE ALSO
        CFLAGS(7)      -- Connection Control Flags.
        XROUTER.CFG(8) -- Main Configuration File.

FEC(1)                   END OF DOCUMENT
