FILES(8)             XROUTER REFERENCE MANUAL               30/10/2023

NAME
        FILES -- Files And Directories Used By XRouter.

DESCRIPTION
        All files and directories required by the system are located
        within a single directory which can be located anywhere and
        have any name.  For the purposes of this document it will be
        called the "root" or "working" directory.  All other
        directories used by XRouter are sub-directories of the
        working directory.

        The working directory should contain at least the XRouter
        program and XROUTER.CFG.  All other files are optional and
        the system will run without them.

        If you want to grant access to remote sysops you will need to
        add a suitably configured PASSWORD.SYS.  If you want to route
        IP, you will need IPROUTE.SYS.  If you want to control TCP/IP
        access, add ACCESS.SYS and USERPASS.SYS.  If you need to
        specify hostnames for fast domain lookup, add DOMAIN.SYS.

        If you add any of the above, you must edit them to suit your
        requirements.  They should be self-documenting, but there is
        also a MAN file for each one.

        If you want the full HELP system (recommended), create a
        sub-directory called HELP and place all the .HLP files into
        it.  Note that the help for the CHAT server goes in
        sub-directory HELP/CHAT, FTP server help goes in HELP/FTP and
        the APRS messaging help goes in HELP/AMSG.

        If you want an INFO system, create the INFO directory and
        populate it with .INF files.  There are some sample .INF
        files included in the distribution package to give you some
        ideas.

        If you want the online manual (recommended), create the MAN
        directory and put the *.MAN files into it.


        Directory Tree
        ~~~~~~~~~~~~~~

          /             - XRouter "root", e.g. C:\XRouter
          /FINGER/      - FINGER files
          /HELP         - English HELP files
          /HELP/AMSG/   - Help for APRS messaging
          /HELP/CHAT/   - Help for chat server
          /HELP/FTP/    - Help for FTP server
          /HELP/FR/     - French HELP files
          /HELP/NL/     - Dutch HELP files
          /HTTP/        - Root for HTTP server (see below)
          /INFO/        - INFO files
          /LOG/         - Activity log files
          /MAN/         - Sysop manual files

        The LOG directory is created automatically when XRouter runs.

        If logging is enabled, daily log files are created within the
        LOG directory.  If IDS logging is enabled, the IDS log files
        are also written to thr LOG directory.

        The HTTP root directory may be relocated (using the HTTPROOT
        directive in XROUTER.CFG).  This allows the HTML files to be
        located somewhere more convenient, even on another drive if
        required.


        Files in XRouter "root" Directory (* = mandatory)
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

          ACCESS.SYS    - TCP/IP access control.
          BOOTCMDS.SYS  - Boot up config commands.
          CRONTAB.SYS   - Event control.
          DEUTSCH.SYS   - German language file.
          DOMAIN.SYS    - TCP/IP hostname resolution.
          ENCAP.TXT     - IPENCAP routes.
          ESPANOL.SYS   - Spanish language file.
          FRANCAIS.SYS  - French language file
          HTTP.ACL      - HTTP Proxy Egress Control.
          HTTP.SYS      - HTTP Rewrite / Proxy Control.
          HTTPBAN.SYS   - HTTP URL block list.
          IGATE.CFG     - APRS IGATE configuration.
          IPROUTE.SYS   - IP routes / configuration.
          LANGS.SYS     - Languages control file.
          NEDERLANDS.SYS - Dutch language file.
          PASSWORD.SYS  - Sysop passwords.
          PPPHOST.n     - PPP configuration files.  
          PPPLOG.TXT    - PPP activity log.
          SOCKS.ACL     - SOCKS proxy egress control.
          TELGUEST.ACL  - Telnet "guest" mode egress control.
          TELPROXY.ACL  - Telnet proxy egress control.
          TELPROXY.MSG  - Telnet proxy welcome message.
          USERPASS.SYS  - User passwords.
        * (XRouter)     - Executable (xrouter / xr32 / xrpi /xrlin)
          XRNODES       - NetRom nodes / routes recovery file.
        * XROUTER.CFG   - XRouter Main Configuration File.

        There are detailed MAN pages for each of the above files in
        section 8 of the manual.

SEE ALSO
        XROUTER.CFG(8) -- Main Configuration File.
        IPROUTE.SYS(8) -- IP routes / configuration File.
        BOOTCMDS.SYS(8) -- Boot up configuraion Commands.

FILES(8)                    END OF DOCUMENT
