;***********************|****** Max Width *****|*********************|
FINGERPORT(7)           XROUTER REFERENCE MANUAL             27/9/2023

NAME
        FINGERPORT -- TCP Port for FINGER Server.

SYNOPSIS
        FINGERPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        FINGERPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        by the FINGER server. If not present, the default is 79.

        The FINGER server allows users to "put a finger on" (i.e.
        find information about) other users. 

        The server is also available on NetRomX service 79.

OPTIONS
        If a single argument is supplied, e.g. "FINGERPORT=79", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "FINGERPORT=79 89", the
        first argument applies to the XRouter stack and the second to
        the host system's stack. The numbers must be separated by
        whitespace

        Setting FINGERPORT to zero on a stack prevents TCP connections
        to the finger server via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

        FINGER is expected to be on port 79. If you "move" the finger
        port, other people's finger clients will not be able to
        connect to your server. This directive is provided ONLY for
        controlling availablity on each stack.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        FING-SRV(9)  -- FINGER server.
        FING-SVC(9)  -- NetRomX FINGER Service.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

FINGERPORT(7)           END OF DOCUMENT
