;*************************** Max Width *******************************
FRACK(7)              XROUTER REFERENCE MANUAL               26/9/2023
 
NAME
        FRACK -- AX25 Frame Acknowledgement Time.

SYNOPSIS
        FRACK=<milliseconds>

DESCRIPTION
        FRACK is an optional PORT configuration directive, used in
        XROUTER.CFG.

        If present, it specified the AX25 "T1" timeout, i.e. FRame
        ACKnowledgement time in milliseconds. If not present, the
        default FRACK is 7000. The value can be changed during run-
        time using the FRACK command.

        After sending an AX25 packet, FRACK is the amount of time
        XRouter will wait for an "ack" before considering the packet
        to be lost.

        The T1 timer starts when the link layer dispatches the packet
        to the MAC (Media Access Control) layer, so you must allow at
        least enough time for (MAXFRAME * PACLEN) packets to be sent,
        plus an ack packet to be received, plus the other end's
        RESPTIME, plus both end's TXDELAYs, plus a generous allowance
        for channel congestion.

        A frack no less than 7000 millisecs is recommended for
        average 1200 baud simplex RF links. Setting this figure too
        low is antisocial, achieves nothing, wastes airtime, and
        could result in the link retrying out.

        However, on fast, wired (e.g. AXUDP) links, 7 secs is
        excessive, and a figure more like 2000 (2 secs) should be
        used.

EXAMPLE
        FRACK=7000 ; 7 seconds

SEE ALSO
        FRACK(1)       -- Display / Set FRACK for a port.
        MAXFRAME(7)    -- Maximum Unacked Frames.
        PACLEN(7)      -- Maximum Packet Length.
        PORTS(6)       -- Ports in XRouter.
        RESPTIME(7)    -- AX25 Delayed Ack Time.
        XROUTER.CFG(8) -- Main Configuration File.

FRACK(7)                  END OF DOCUMENT
