FTP-CMDS(1)             XROUTER REFERENCE MANUAL            16/10/2023

NAME
        FTP-CMDS -- FTP Server Commands.

DESCRIPTION
        XRouter's FTP server currently accepts the following commands:


           ABOR   CDUP   CWD    DELE   FEAT   HELP   LIST   MDTM
           MFMT   MKD    MODE   NLST   NOOP   PASS   PASV   PORT
           PWD    QUIT   REST   RETR   RMD    RNFR   RNTO   SIZE
           STOR   STRU   SYST   TYPE   USER


        All commands are case-insensitive, thus "cwd", "CWD" and
        "cWd" are equally valid. Pathnames are case-insensitive on
        DOS and Windows versions of XRouter, but are case-sensitive
        on Linux versions (XRLin / XRPi).

        Both UNIX style (e.g. /pub/fred) and DOS style (e.g.
        \pub\fred) pathname conventions are accepted.

        Disk drive letters (e.g. "C:") apply only to XR16 and XR32,
        but not to Linux versions.

        Unlike DOS, the server does not maintain separate "working
        directories" for each drive, so pathnames which include a
        drive letter must start at the root of that drive.  e.g.
        "c:mydir\fred.txt" is not valid, while "c:\mydir\fred.txt" is.

        The FTP commands are described in detail below:


        ABOR -- Abort data connection.

            Syntax: ABOR

            The ABOR command tells the server to abort any data
            transfer currently in progress and close the data
            connection.  The control connection is not closed.

            If the data connection is not open, this command has
            no effect.


        CDUP -- Change Directory Up By One Level

            Syntax:  CDUP

            The CDUP command changes the current working directory
            up one level to the parent directory, i.e. it performs
            the function of "CWD .."

            This command has no arguments, and if already at the
            root it has no effect.


        CWD  -- Change Working Directory

            Syntax:  CWD [drive:\]<path>

            The CWD command changes the current working directory
            (and drive if necessary) for the FTP session.

            Examples:

                CWD FRED        Change to sub-directory FRED.
                CWD ..          Change up one level to parent dir.
                CWD /           Change to root directory
                CWD /FRED/JIM   Change to JIM subdirectory of FRED.


        DELE -- Delete file(s).

            Syntax:  DELE [drive:\][dir\]<mask>

            Examples:

                DELE JIM.TXT         Delete JIM.TXT from current dir.
                DELE /FRED/DOG.EXE   Delete DOG.EXE from dir. /FRED
                DELE *.BAT           Delete files with .BAT extension.

            Notes:  Wildcards '*' and '?' are accepted.


        FEAT -- Feature negotiation mechanism.

            Syntax:  FEAT

            The FEAT command requests the server to list all extension
            commands, or extended mechanisms, that it supports. 

 
        HELP -- Display help for FTP server commands.

            Syntax:  HELP [command]

            Examples:  HELP        Displays basic info / cmd list.
                       HELP CWD    Gives help for the CWD command.

            Some FTP clients may intercept the HELP command to
            give help on client commands.  In this case, the
            REMOTEHELP command, if it is implemented should
            translate to a server HELP command. If not, the client
            may have a command which passes commands "RAW" to the
            server.  If all else fails, TELNET to port 21 and the
            HELP command will work.


        LIST -- lists FTP server directory contents.

            Syntax:  LIST [drive:\][dir\][mask]

            The LIST command causes a directory listing to be sent
            from the FTP server to the client over the data
            connection.  If the data connection cannot be
            established, the command will fail.

            The optional argument consists of a directory path and 
            filename mask.  If no path is specified, the current 
            directory is assumed.  If no mask is specified, "*"
            (all files) is assumed.  Wildcards '*' and '?' are
            accepted. 

            Examples:
                LIST              Show all files in current directory
                LIST C:\PUB       Show all files in PUB subdir of C:
                LIST /USR/*.EXE   Show all .exe files in /USR dir.

            See also:  NLST -- List names only


        MDTM -- Enquire file modification date and time.

            Syntax:  MDTM [drive:\][dir\]<filename>

            The MDTM command is used to obtain the "last modifed"
            date and time of the specified file.

            Examples:  MDTM XROUTER.CFG
                       MDTM C:\MyDocs\plans.txt


        MFMT -- Modify the last modification time of a file. 

            Syntax:  MFMT <timeval> [drive:\][dir\]<filename>

            Example:  MFMT 20020717210715 Fred.txt
                      (sets file date/time to 17/7/2002 21:07:15)


        MKD  -- Make new directory.

            Syntax:  MKD [drive:\]<pathname>

            The MKD command creates a new directory of the
            specified name.  If pathname is not fully qualified,
            the new directory is created within the current
            working directory.

            Examples:  MKD FRED
                       MKD C:/JIM/BILL

            See also:  RMD -- Remove directory


        MODE -- Specifies the data transfer mode.

            Syntax:  MODE <mode_code>

            MODE specifies how the data is to be formatted and 
            transferred via the data connection.  Mode codes are
            as follows:

                B - Block         Data is sent in blocks
                C - Compressed    Data is compressed
                S - Stream        Data sent as stream of characters

            The default transfer mode, which is the only one
            currently implemented, is Stream.  The command is
            included to prevent unnecessary error replies.

            Examples:  MODE S   Sets (S)tream transfer mode.


        NLST -- Lists directory contents in short form.

            Syntax:  NLST [<filespec>]

            The NLST (Name List) command causes a directory
            listing to be sent from the FTP server to the client
            over the data connection.  If the data connection
            cannot be established, the command will fail.

            The optional argument consists of a directory path and 
            filename mask.  If no path is specified, the current
            directory is assumed.  If no mask is specified, "*"
            (all files) is assumed.  Wildcards '*' and '?' are
            accepted. 

            The listing consists of filenames only, without size,
            date and other supplementary information.

            Examples:  NLST
                       NLST K:\PUB
                       NLST /USR/*.EXE

            See also:  LIST -- List directory contents


        NOOP -- (NO OPeration) does nothing. 

            Syntax:  NOOP

            The NOOP command does not affect anything, and its
            only action is to cause the server to send an "OK"
            reply.  It is perhaps useful for testing that the
            control connection is still functioning.


        PASS -- Specifies user password at login.

            Syntax:  PASS <password>

            The argument to the PASS command is either a string of
            up to 5 characters in response to the secure password
            challenge or, for use on secure links only, the
            password itself.  The string may not contain spaces.

            The command must be immediately preceded by the USER
            command, which causes the system to reply with a
            matrix consisting of 5 lines of 5 numbers thus:

                4 1 6 3 7
                3 5 2 6 3
                7 1 9 2 4
                2 7 1 4 6
                3 5 2 6 1

            The remote sysop must then choose ONE of the lines,
            and send the PASS command followed by the 5 characters
            from the password string which correspond to the 5
            numbers on the chosen line.  There must be a space
            after PASS but no spaces between the characters.

            Examples:  PASS RETAW        <-- Matrix response
                       PASS squirrels    <-- Raw password

            If the sysop has connected on a port which has SYSOP=1
            in the config file (e.g. a secure wire link), the
            response to this command is ignored, and the sysop is
            granted full access.

            See also:  USER -- Specify your username.


        PASV  -- Use "passive" transfer mode.

            Syntax:  PASV

            Normal FTP relies on the server being able to initiate
            a data connection to TCP port 20 on the client host.
            This method may however not work if the client is
            located "behind" a firewall or connection multiplexer.

            Passive mode opens a data connection on the server,
            informs the client of the IP address and port number,
            and waits for the client to connect to it.  It can
            therefore work via firewalls.


        PORT -- Specifies IP address and port for the data connection.

            Syntax:  PORT h1,h2,h3,h4,p1,p2

            The PORT command specifies the IP address and TCP port
            number to be used by the data connection.  The
            argument is the concatenation of a 32 bit IP address
            and a 16 bit TCP port number, split into 8 bit fields,
            each field being transmitted as a decimal number.  The
            fields are separated by commas, and the high order
            fields are transmitted first.

            Example:  PORT 44,131,91,2,4,1
                      Specifies IP address 44.131.91.2 and TCP
                      port number 0401 (1001 decimal)

            Under normal circumstances this command is not needed.
            The data connection defaults to TCP port 20 at the
            client's IP address of the control connection.
            However, it allows data to be sent to a different host
            if required.


        PWD  -- Print Working Directory.

            Syntax:  PWD

            The PWD command causes the full path of the user's
            current working directory to be displayed via the
            control connection.

            See also: CWD -- Change Working Directory


        QUIT -- Terminates an FTP session.  

            Syntax:  QUIT

            If a file transfer is not in progress, the QUIT
            command terminates the FTP session and closes the
            control connection.

            If file transfer is in progress, the control
            connection will remain open until transfer is
            complete, allowing the result code to be sent.  The
            control and data connections will then close.

            An unexpected close on the control connection will
            abort any data transfer currently in progress.

            See also:  ABOR -- Abort current command.


        REST -- Restart of Interrupted Transfer.

            Syntax:  REST <offset>

            The REST command specifies an offset from which a file
            transfer should be resumed. The REST command does not
            actually initiate the transfer. After issuing a REST
            command, the client must send the appropriate FTP command
            to transfer the file. The server resumes file transfer at
            the specified offset.

            Example: REST 32740

            NOTE: At present this only works for BINARY transfer mode!


        RETR -- Retrieve (download) file.

            Syntax:  RETR [drive:\][dir\]<filename>


            The RETR command causes the named file to be sent from
            the FTP server to the client over the data connection.
            If the file can't be found, or access is denied, or
            the data connection can't be opened, an appropriate
            error message is returned.

            Examples:  RETR JIM.TXT
                       RETR ../FRED/DOG.EXE
                       RETR C:\CONFIG.SYS

            Notes:  Single files only, wildcards not accepted.

            See also:  PORT -- Host/port for data connection.
                       STOR -- Send a file to the server.


        STOR -- Store (upload) file.

            Syntax:  STOR [drive:\][dir\]<filename>

            The STOR command requests the FTP server to accept
            data via the data connection and store it as a file
            with the specified name.

            If the file specified in the pathname already exists
            at the server, it is overwritten by the new data.  The
            overwrite doesn't take place until the file has been
            correctly received, which prevents a critical file
            being lost if the data connection fails. 

            Examples:  STOR JIM.TXT
                       STOR /FRED/DOG.EXE

            See also:  RETR -- Retrieve a file from the server.


        RMD  -- Remove Directory.

            Syntax:  RMD [drive:\]<pathname>

            The RMD command deletes the directory specified by
            <pathname> from the FTP server, providing you are the
            owner of that directory and have write access.

            Examples: RMD FRED
                      RMD K:/JIM/BILL

            See also: MKD -- Make directory


        RNFR -- Rename From

            Syntax:  RNFR [drive:\][dir\]<filename>

            The RNFR command specifies the old pathname of a file
            which is to be renamed, and must be immediately
            followed by an RNTO command.  The two commands
            together cause a file to be renamed.  If the file is
            not found the request is refused.

            Examples: RNFR ../JIM.TXT
                      RNFR K:/FRED/DOG.EXE

            See also:  RNTO -- Rename To


        RNTO -- Rename To

            Syntax:  RNTO [drive:\][dir\]<filename>

            The RNTO command specifies the new pathname of a file
            which is being renamed, and must immediately follow an
            RNFR command.  The two commands together cause a file
            to be renamed.

            If the new pathname isn't valid, the request is refused.

            Examples:  RNTO DOG.TXT
                       RNTO K:/FRED/CAT.EXE

            See also:  RNFR -- Rename From.


        SIZE -- Enquire Size of File.

            Syntax:  SIZE [drive:\][dir\]<filename>

            The SIZE command returns the transfer size of the file
            whose pathname was supplied, or an error response if the
            file does not exist, the size is unavailable, or some
            other error has occurred.  The value returned is in a
            format suitable for use with the RESTART (REST) command
            for mode STREAM, provided the transfer mode and type are
            not altered.


        STRU -- Specify File Structure.

            Syntax:  STRU <structure_code>

            STRU specifies the internal structure of the files
            being transferred, i.e.  how the data is organised
            within them.  Structure codes are as follows:

                F - File       No record structure (contiguous bytes)
                R - Record     Collection of sequential records
                P - Page       File is composed of independent pages

            The default structure, which is the only one currently
            implemented, is (F)ile.  The command is included to
            prevent unnecessary error replies.

            Example:  STRU F   Sets (F)ile structure.


        SYST -- Operating system enquiry.

            Syntax:  SYST

            The SYST command is used to discover what type of
            operating system is being used on the server.

            The first word of the reply is one of the agreed
            system names, in this case Windows NT. The rest of the
            reply gives the server version number and byte size.


        TYPE -- Specifies the data representation type.

            Syntax:  TYPE <type_code>

            The argument to the TYPE command specifies how the
            data is to be translated between storage and transfer.
            Type codes are as follows:

                A - ASCII      Text.  End of line is <CR><LF>   
                I - Image      No translation.  Bytes stored as rcvd.
                L <bytesize>   Size of local storage bytes

            Examples:  TYPE A    Specifies Ascii type.
                       TYPE L 8  Local byte size of 8 bits


        USER -- Specify user name for login.

            Syntax:  USER <username>

            The argument to the USER command is a string of up to
            8 characters specifying the user's login name
            (usually callsign).  The string must not contain
            spaces.

            Users are not allowed access to the system without
            logging in.

            If the username (or callsign) exists in the
            PASSWORD.SYS file the server sends a grid of 5x5
            numbers (see PASS command) generated from the user's
            stored password.  If the username is not found, an
            error message is sent instead, and access is denied.

            The USER command must be immediately followed by the
            PASS command.

            Example:  USER SYSOP   Enters login name as "SYSOP"
                      USER G8PZT   Use callsign


            Note: Because the FTP server allows you to use any
            string of characters as a name, you may set up
            different passwords for different login names, and
            these may be in addition to your callsign, which is
            the one used for ax25 sysop access.

            See also:  PASS -- Specify password.


SEE ALSO
        FTP-SRV(9) -- FTP Server.

FTP-CMDS(1)                 END OF DOCUMENT
