;***********************|****** Max Width *****|*********************
FTP-SRV(9)              XROUTER REFERENCE MANUAL            27/9/2023

NAME
        FTP-SRV -- FTP Server.

DESCRIPTION
        XRouter's inbuilt FTP sever allows remote sysops to upload,
        download, list, rename and delete files, create and remove
        directories etc., which is useful when XRouter is located
        somewhere inaccessible, such as a garage or remote hilltop.

        For example, new configuration and program files may be
        uploaded, and the system can then be restarted to perform a
        remote upgrade.

        The FTP server is only available to sysops.  It is protected
        by a password grid, and is only accessible to those who have
        a password registered in the sysop password file,
        PASSWORD.SYS.

        Access to all files, drives and directories is unrestricted,
        because the FTP server is intended for remote system
        maintenance, not as a public file repository.  The HTTP and
        NFTP servers may be used for that purpose instead.

        The FTP server uses standard FTP commands, with the
        exception of the USER and PASS login sequence, which are
        tailored for use on a radio channel: 

        In addition to the normal password prompt, the server also
        presents the user with a matrix of 5 lines of 5 numbers.  The
        user may respond either with a string of characters, as with
        secure sysop login, or with the full password in plain text.

        The grid response would be used on a public RF channel, and
        the plain text password on a secure RF channel or wired link.

        The server was originally intended for manual operation via
        RF links, but automated FTP clients may be used on secure
        links, because the password matrix is ignored by all types of
        FTP client so far tested.  They simply respond with the plain
        text password.

        There are no automated FTP clients that respond to the
        password grid with a secure response, so you cannot (safely)
        use them via an unsecured RF link.  However, if you leave the
        client's password field empty, it will usually prompt you to
        enter a password upon connection, at which point you can
        respond to the grid challenge.

        You are advised not to transfer a password file or any other
        sensitive material via insecure RF links.

        The directory format is "Windows_NT" because that is the
        format which gives the best results with the widest range of
        FTP clients.

        There is comprehensive help available at the FTP command
        prompt, provided you have placed the FTP help files in the
        HELP/FTP directory.

        The transport mechanism for FTP is TCP/IP, therefore you must
        have the appropriate IP routing configured if you wish to use
        it via XRouter's IP stack.  No configuration (other than some
        form of TCP/IP network) is required for operation via the
        host system's IP stack.

        The TCP port used by the FTP server defaults to the standard,
        i.e. 21.  This may be changed for XRouter and/or the host
        system's TCP/IP stacks using the optional FTPPORT directive
        in XROUTER.CFG.

        Access to the server may be controlled according to the
        client's source IP address, by using appropriate entries in
        ACCESS.SYS.
 
        The FTP server commands are described in detail in the sysop
        command reference section.

SEE ALSO
        ACCESS.SYS(8)  -- TCP/IP Access Control File.
        AXSCTRL(9)     -- TCP/IP Access Control.
        FTP-CMDS(1)    -- FTP Commands.
        FTPPORT(7)     -- TCP Port for FTP Server.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

FTP-SRV(9)              END OF DOCUMENT
