FTP(1)                 XROUTER REFERENCE MANUAL               8/9/2023

COMMAND
        FTP -- Invoke FTP Client.

SYNOPSIS
        FT[p] [hostname | ipaddr | nickname]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The FTP command invokes an inbuilt FTP (File Transfer
        Protocol) client. This client is part of XRouter, and has
        nothing to do with the host operating system.

        The client currently has 67 commands, all of which have brief
        help and syntax. Commands may be abbreviated. The command
        list is as follows:

          ?           <           abort       account     append
          ascii       bell        binary      bye         case
          cd          cdup        close       dir         delete
          get         hash        help        idle        keep
          lcd         ldel        ldir        ls          list
          lmkdir      lpwd        lrmdir      lren        lview
          mdelete     mget        mkdir       modtime     mput
          newer       nlist       open        passive     preserve
          progress    prompt      put         pwd         quit
          quote       reset       restart     recv        reget
          rename      rhelp       rmdir       rstatus     runique
          send        site        size        sndport     status
          sunique     system      timeout     type        user
          verbose     view

        Use "? <cmd>" for specific help on <cmd>, for example:

            ? ldir
            LDIR    List files in local directory
            Syntax: LDI[r] [local-path]

        The Q)uit command returns you to the node.

OPTIONS
        Typing "FTP" by itself, with no arguments, starts the client,
        but doesn't connect to a server. Local commands such as LDIR
        LCD etc can be performed. A connection can be initiated using
        the OPEN command.

        If the argument to "FTP" or "OPEN" is a hostname or IP
        address, the client connects to the standard TCP port (21)
        on that target.

        If the target server isn't on TCP port 21, the port number
        can be specified using a second argument, e.g.

            FTP 192.168.1.203 31

        Commonly-used targets can be given a "nickname", to simplify
        the connection process. Nicknames are specified in
        FTPCLI.SYS, along with connection details allowing automated
        login.

EXAMPLES
        FTP                   -- Start FTP without connect to server
        FTP 192.168.1.3       -- Connect to 192.168.1.3 tcp port 21
        FTP g8pzt.ath.cx 2521 -- Connect to g8pzt.ath.cx port 2521
        FTP gb7kr             -- Automated connect, account "gb7kr"

NOTES       
        Some may wonder why XRouter includes an FTP client, when
        Linux already has one?

        One good reason is that it allows FTP over Amprnet, which is
        something that's not easy to set up in Linux itself.

        Secondly, I had a need for it. I won't elaborate why, just
        to say it has proved very useful to me. It might even prove
        useful to you. If not, just ignore it!

SEE ALSO
       FTP-SRV(9)      -- FTP Server.
       FTPCLI.SYS(8)   -- FTP Client Account File.
       NFTP(1)         -- NetRom File Transfer Protocol Client.

FTP(1)                  END OF DOCUMENT
