;***********************|****** Max Width *****|*********************|
FTPPORT(7)              XROUTER REFERENCE MANUAL             27/9/2023

NAME
        FTPPORT -- TCP Port for FTP Server.

SYNOPSIS
        FTPPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        FTPPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        by the FTP server. If not present, the default is 21.

        The FTP server is mainly intended for use by sysops.

OPTIONS
        If a single argument is supplied, e.g. "FTPPORT=21", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "FTPPORT=21 31", the
        first argument applies to the XRouter stack and the second to
        the host system's stack. The numbers must be separated by
        whitespace

        Setting FTPPORT to zero on a stack prevents TCP connections
        to the server via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        FTP-SRV(9)     -- FTP server.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

FTPPORT(7)           END OF DOCUMENT
