;***********************|****|* Max Width *|***|*********************|
FWD.SYS(8)              XROUTER REFERENCE MANUAL             29/3/2024

NAME
        FWD.SYS -- Mailbox Forwarding Control File.

DESCRIPTION
        The optional file FWD.SYS, which resides in the PMS folder,
        controls when & how queued mail is delivered to neighbours.

        It is read "live" during each forwarding run, so it can be
        edited on the fly, and any edits take effect immediately.

FORMAT
        Comment lines are allowed. They must begin with hash (#) or
        semicolon (;) in the leftmost column.

        There is one "block" of lines controlling the forwarding for
        each neighbour BBS.

        Each block starts with: "@<bbs> <options>"

            <bbs>      is the callsign (without SSID) of the target
                       mailbox. This must exactly match a <send_via>
                       in DISTRIB.SYS.

            <options>  are as follows:

                       F = Forward mail, if we have any to send
                       P = Poll for mail even if we have none to send

        The second line of each block specifies the days of the week
        (0=Sunday) on which forwarding to this neighbour is allowed.

            For example: "0,3-4,6" (no whitespace)

        The third line of each block specifies the hours of the day
        during which forwarding to this neighbour is allowed

            For example: "4-12,14,17-21" (no whitespace)

        Subsequent lines in the block are the "connection script" as
        follows:

            T <secs>   specifies a timeout for the connection
            C <call>   initiates connection (waits for "Connected to")
            S <text>   sends <text>
            W <text>   waits for <text> in the received data

        Each "block" must end with a short line of dashes: "-------"

EXAMPLES
        # Forward and poll VE2PKT midnight to 8am, weekends only:
        #
        @VE2PKT FP
        0,6
        0-8
        C KIDDER
        C PKTXRP
        C VE2PKT
        ----------

        # Forward to GB7NXT any day, any time, but don't poll

        @GB7NXT F
        0-6
        0-23
        C KIDDER
        C GB7NXT
        W NXTNOD:GB7NXT}
        S BBS
        ------
        ; Forward and poll VA2OM any day, mornings & evenings only:
        ;
        @VA2OM FP
        0-6
        8-11,17-20
        C KIDDER
        C VA2OM-14
        S PMS
        ----------

SEE ALSO
         FF(4)          -- Force Forwarding.
         FP(4)          -- Force Polling.
         SF(4)          -- Stop Forwarding.
         VF(4)          -- View Forwarding.
         DISTRIB.SYS(8) -- Mail Distribution Control File.
         PMS(9)         -- About the Mailbox.

FWD.SYS(8)                   END OF DOCUMENT
