GNET(1)                 XROUTER REFERENCE MANUAL            16/10/2023

COMMAND
        GNET -- Display / Set GNET parameters.

SYNOPSIS
        G[net] A[ddress] [addr]
        G[net] R[oute] A[dd] <gnetaddr>[/bits] <nodecall>
        G[net] R[oute] D[rop] <gnetaddr> <bits>
        G[net] R[oute] L[ist]
        G[net] T[tl] [1-255]

AVAILABILITY
        Sysops-only.

DESCRIPTION
        The GNET commands allow sysops to display and set the GNET
        parameters such as address and routing.

        GNET is an experimental global network, which uses ip-like
        addressing and routing to tunnel traffic across the NetRom
        network, unrestricted by NetRom horizons.
  
        Not only does GNET offer global routing between all users,
        but it also offers up to 65536 possible session types
        between those users. 
 
OPTIONS
        "GNET ADDRESS" is used to display or set the XRouter's GNET
        address. See NOTES below for details of address format.
        The GNET address defaults to 0.0.0.0 which disables all GNET
        activity.

        "GNET ROUTE ADD" is used to add a route to the GNET routing
        table. The first argument is the address to be routed, with
        optional mask. e.g. 131.90.1.2/32 means "match all 32 bits",
        whereas 131.90.1.0/24 means "match the most significant 24
        bits", and would route all 256 addresses from 131.90.1.0 to 
        131.90.1.255. The second argument <nodecall>, is the NetRom
        callsign of the GNET gateway to which the addresses should
        be routed.

        "GNET ROUTE DROP" removes a routing entry from the GNET
        routes table. The arguments are the GNET address and mask.

        "GNET ROUTE LIST" lists all the GNET routes in the table.

        "GNET TTL" sets the "Time To Live", i.e. the maximum number
        of hops a packet is allowed to make. A low TTL helps to
        suppress bouncing packets in the event of a routing loop.
        The default is 25

EXAMPLES
        GNET ADDR 147.22.14.2
        GNET ROUTE ADD 131.91.2.0/24 G8PZT
        GNET ROUTE DROP 131.91.2.0 24
        GNET TTL 15

FILES
        There is no provision in XROUTER.CFG for spcifying the GNET
        address and routing, but this can be achieved by using the
        GNET commands in BOOTCMDS.SYS.

NOTES
        GNET addressing is based on numeric country and region codes
        and the addresses look like IP addresses, although this
        protocol does not involve IP at all.

        Addresses are of the form <country>.<region>.<router>.<user>
        allowing up to 255 countries, 255 regions per country, 255
        routers per region and 255 users per router. But this is not
        rigid; Each country may assign the regions as it sees fit.

        Country codes are the same as the ones used for amprnet,
        e.g. 131 is the UK, 147 is New Zealand etc. Region codes can
        be the same as the amprnet regions. Router codes can be
        assigned by local agreement, and user codes are assigned by
        the router sysops.

HISTORY
        GNET was invented in 2002 by G8PZT, and was implemented in
        XRouter. The development name adopted for the system was
        "GlobalNet", because it was a global networking system!
        However, it later transpired that the name was being used
        by an ISP, so the shorter name "GNET" (pronounced "jee-net")
        was adopted to avoid confusion.

        The system showed great promise, but never took off because
        there was no sysop documentation, and interest in DOS
        XRouter was waning as more people wanted to run their
        systems on Windows. The author's attention turned to more
        urgent matters, and no more development was done. There was
        so much more that could have been done.

        The GNET protocol and commands were retained when XRouter
        was ported from DOS to Windows and thence to Linux.
        Development may resume in future. In the meantime, sysops
        are encouraged to experiment with this mode.

LIMITATIONS
        There is currently no mechanism for resolving user callsigns
        to GNET addresses. This is a vital part of the system, which
        will be the next component to be added.
        
CAVEATS
        GNET relies on the NetRom network to provide links between
        its gateways. In order to route GNET traffic to a gateway,
        that gateway must be present in your node table

SEE ALSO
        GPING(1)    -- Send GNET Echo Requests
        IP-CODES(9) -- IP Country Codes

GNET(1)                    END OF DOCUMENT
