GPING(1)                XROUTER REFERENCE MANUAL            16/10/2023

COMMAND
        GPING -- Send GNET Echo Request.

SYNOPSIS
        GP[ing] <addr> [len [sec]]

AVAILABILITY
        All users, except guests.

DESCRIPTION
        Sends GCMP (GlobalNet Control Message Prototcol) echo
        request(s) to the specified GNET (GlobalNet) address, for
        the purposes of route testing.

        An optional data portion may be specified, and the echo
        request may optionally be repeated at a specified interval.

        If there is a reply it will be displayed. For repeating pings 
        the system displays the number sent/rcvd, the average round 
        trip time in milliseconds, and the success rate.  The "wait 
        for reply" process may be cancelled at any time by entering 
        <CR> by itself.

OPTIONS
        <addr> is the GNET address of the target.

        [len] specifies the number of additional data bytes to send
              in the request packet. Default is 0.

        [sec] is the interval between requests. If present, this
              causes the ping to repeat every [sec] seconds. This
              field requires the [len] field to be present.       

EXAMPLES
        GPING 131.91.2.1           Single ping of minimum size
        GPING 131.91.2.1 50        Single ping with 50 bytes data
        GPING 131.91.2.1 512 10    Ping 512 bytes every 10 secs

NOTES
        See the MAN page for GNET(1) for more information about GNET.

CAVEATS
        In order for this command to work, XRouter's GNET address must
        be defined, and there must be a route to the destination.

        If XRouter's GNET address isn't defined, the response will be
        "Error 5 (bad configuration)", and if no route is defined
        the response is "Error 4 (no route)".

        If no response is received, the target doesn't exist, or the
        downstream routing is faulty, or there is no return route
        defined.

SEE ALSO
        GNET(1) -- GNET Configuration Commands

GPING(1)                    END OF DOCUMENT
