HELP(9)                 XROUTER REFERENCE MANUAL            29/12/2023

NAME
        HELP -- Help system.

DESCRIPTION
        Basic syntax help for most commands is built into XRouter,
        and is available using the query (?) command, e.g. "? N"
        displays the syntax of the NODES command.

        More detailed help is implemented as separate files in the
        HELP directory, allowing you to customise it, and add extra
        help topics as desired.  Each topic occupies a separate file,
        with the filename the same as the topic name. 

        The "H *" command displays a sorted directory of all the
        files with the extension ".HLP" (i.e. "topics"). The
        extension is not displayed. "H <topic>" displays the contents
        of that topic's file. e.g. "H DX" shows help for the DX
        command. If the topic is mis-spelled, XRouter lists the
        topics with similar names.

        The help files don't occupy much space, but you may choose to
        omit some or all of them if you are running a system with
        limited storage.

        In addition to the HELP system, sysops will find more
        detailed information in the "sysop manual" using the MAN
        command.

FILES
        Help files are normal text files, with the extension changed
        to ".HLP". They may be created and edited using a simple text
        editor such as Notepad (windows) or Leafpad, nano etc (Linux).

        All help files are located within the HELP directory, which
        itself is in the directory containing XRouter.

        English help files should be placed in the HELP directory
        itself. Help files for other languages should be placed in
        sub-directories of the HELP directory. For example, French
        help files should be in HELP/FR/, Spanish help files in
        HELP/ES/, German help files in HELP/DE/, and Dutch help files
        in HELP/NL/.

        Filenames, including the extensions, MUST be in UPPER CASE.
        Lower case filenames and files without the .HLP extension are
        ignored.

        Try to keep the filenames concise, to save excessive typing.
        The longer the filename, the more likely that a user will
        mis-spell it.

        Within the .HLP files, lines beginning with a semicolon ';'
        are not displayed to users, so you can use them for comments,
        such as file modification details.

        Help files can be viewed from the console using <ALT+H>
        followed by <H>. This browser window is only around 76
        characters wide, so try to keep the lines shorter than this,
        to preserve formatting. In any case, lines longer than 72
        characters are bad practice, typopgraphically-speaking.

HISTORY
        The help system originated long ago on DOS XRouter, and in
        those days there was only limited association between filename
        extensions and programs. I.e. in most cases, the extension
        itself had no real meaning, other than to serve as a reminder
        to humans what the file contained. Which is exactly why the
        XRouter help files have the extension ".HLP", to distinguish
        them from ".MAN" (manual), ".SYS" (system), .CFG
        (configuration) and so on.  In those days, most programs
        could view and edit a text file, no matter what the extension.

        Unfortunately, Windows assumes that a file with the extension
        ".HLP" is a Windows help file, and that ".SYS" is a Windows
        system file. If you double click these files, Windows
        complains that the format is wrong.

        It would be more convenient for *Windows* if the files had
        the extension .TXT instead of .HLP, but how would we then know
        that they were help files? Therefore, XRouter continues to use
        the traditional file names.

SEE ALSO
        HELP(1) -- User Help Command.
        MAN(1) -- Online Sysop's Manual.

HELP(9)                     END OF DOCUMENT
