;***********************|****|* Max Width *|***|*********************|
HOLD.SYS(8)             XROUTER REFERENCE MANUAL             29/3/2024

NAME
        HOLD.SYS -- Control File for Mail Holding.

DESCRIPTION
        The optional file HOLD.SYS, which resides in the PMS
        subdirectory, controls the "holding" of messages.

        It is read "live" upon receipt of each new mesaage, so it can
        be edited on the fly, and any edits take effect immediately.

        Entries in this file allow messages to be automatically held
        for review depending on the contents of its TO, FROM, or AT
        fields, and whether or not it was entered locally.

        Held messages are not forwarded, and are only visible to
        sysops.

FORMAT
        Comment lines are allowed. They must begin with a hash (#) or
        a semicolon (;) in the leftmost column.

        Each "active" line must have exactly 5 fields as follows:

            <source> <type> <to>  <from>  <at>

        <source> can be 'L' for "locally entered", or '*'.

        <type>   is the message type, e.g. 'P'", 'B', 'A', 'T' etc.

        <to>     is the addressee of a private message or the
                 "category" of a bulletin.

        <from>   is the callsign of the message creator.
 
        <at>     is the callsign of the destination mailbox (personal
                 mail and "targeted" bulletins), or the "distribution
                 area for a bulletin, e.g. "GBR".

OPERATION
        Rules are processed in the sequence in which they are
        declared in the file.

        If all 5 fields of any rule match characteristics of a
        message, that message is held.

EXAMPLES
        The first example holds all bulletins addressed to PORN, and
        all locally-entered mail of any type:

            # Source Type To    From  At
            # ==========================
                *    B    PORN  *     *
                L    *    *     *     *

        The next example holds locally entered bulletins, except those
        with a blank AT field. This allows users to post bulletins
        which stay on this bbs with no interference:

            # Source Type To    From  At
            # ==========================
               L      B    *    *     ?*

        The next example holds all bulls from LU9DCE, and demomstrates
        the use of semicolons instead of hashes for comment lines:

            ; Source   Type  To      From     At
            ; ==================================
                 *       B    *      LU9DCE   *

        Finally, hold all private mail addresed to "g9pzt":

            ; Source   Type  To      From     At
            ; ==================================
                 *       P    G9PZT  *        *

SEE ALSO
        HOLD(4) -- Hold a Message.
        KH(4)   -- Kill Held Mail.
        LH(4)   -- List Held Mail.
        UH(4)   -- Un-hold Messages.
        PMS(9)  -- Avout the Mailbox.

HOLD.SYS(8)                  END OF DOCUMENT
