HTTP-PROXY(9)           XROUTER REFERENCE MANUAL            17/10/2023

NAME
        HTTP-PROXY -- HTTP Proxy / Tunnel.

DESCRIPTION
        HTTP Proxy
        ~~~~~~~~~~

        The HTTP proxy accepts requests on the normal HTTP port and
        forwards them to another server.

                                XRouter          (google.com)
             .------.          .-------.          .--------.
             | user |-- HTTP --| proxy |-- HTTP --| target |
             '------'    ^     '-------'     ^    '--------'
             (GET http://www.google.com/)  (GET /)


        If a client sends an HTTP request containing an "absolute"
        rather than relative URL, e.g. "GET http://www.google.com/",
        XRouter's HTTP server recognises that this is not a "local"
        request, and opens an HTTP connection to the target server, in
        this case www.google.com.  It then passes a modified request
        and any subsequent HTTP headers to the target server, and
        passes any responses back to the client.

        Apart from rewriting the request to remove the http:// and
        the target hostname, the proxy is fully transparent (a non-
        transparent proxy rewrites the request headers).

        If the target connection could not be established within a
        reasonable time (controlled by PROXYTIMEOUT in HTTP.SYS), an
        HTTP error message is returned to the client, and the client
        connection is closed.


        Downstream Proxy
        ~~~~~~~~~~~~~~~~

        XRouter's HTTP proxy may be configured to pass selected
        traffic to a "downstream" proxy.  This is enabled by using a
        directive with the following format in HTTP.SYS: 

            PROXY <ipaddr> <port> <subnet_mask>

            e.g. "proxy 44.131.91.245  80  255.0.0.0"

        <ipaddr> is the IP address of the downstream proxy.

        <port> is the TCP port number of the downstream proxy.

        <subnet_mask> when combined with the proxy address specifies
                      the range of addresses which are on the same
                      subnet as the downstream proxy. These addresses
                      bypass the downstream proxy, i.e. XRouter will
                      connect directly to them instead of via the
                      downstream proxy.

        This kludge allows 44-net systems to use a further proxy to
        gain a public (Internet) IP address when connecting non-44
        websites.  This is necessary because 44-net routing is
        unreliable at best, i.e. if a 44-net browser tries to
        connect directly to Google, the reply probably won't get
        routed back.

        For example, imagine a mobile station, consisting of a web
        browser and XRouter, with an IP/AX25 link to a nearby gateway,
        but no Internet connection. The IP address used over the
        radio link is 44.131.91.3.  The browser has been configured
        to use XRouter's HTTP proxy, which means the IP source address
        for all HTTP traffic from this station is 44.131.91.3.


         192.168.0.1<->192.168.0.2     62.31.206.176 <-> 173.194.41.99
          .------.    .-------.             .-------.       .--------.
          | user |----| proxy |-- RF Link --| proxy |- Inet-| Google |
          '------'    '-------'             '-------'       '--------'
                     44.131.91.3 <------> 44.131.91.245
            (mobile station)               (gateway)


        Via the nearby gateway, whose IP address is 44.131.91.245,
        the mobile station can happily browse 44-net (amprnet)
        websites. But when it tries to use Google, the replies
        aren't routed back.

        However, if the local gateway has been set up with the
        above PROXY command, the 44.x.x.x sites are connected directly
        by the mobile XRouter's proxy (routed via the gateway), whilst
        the non-44 sites are connected via the gateway's HTTP proxy.
        At this second proxy, they gain a 62.31.206.176 source
        address, which is reliably routable and doesn't rely on the
        co-operation of others in the amprnet.

        The obvious question is, why not use the gateway's proxy
        directly, using NAT to translate the browser's IP address to
        44.131.91.3?  The answer is that Windows' TCP/IP settings are
        tailored for fast wired links and are unsuitable for use via
        packet radio. The intermediate (mobile) proxy makes the TCP/IP
        radio-friendly.


        HTTP Tunnel
        ~~~~~~~~~~~

        The HTTP tunnel allows users located behind a corporate
        firewall, which blocks all non-HTTP traffic, to access regular
        telnet destinations. A Java client applet, such as XWEB.CLASS
        (supplied) would be typically be used to set up the connection
        through the tunnel.

             .--------.          .------.            .--------.
             | client |-- HTTP --| XRouter |-- Telnet --| target |
             '--------'          '------'            '--------'

        All traffic between the Java client and XRouter is carried on a
        regular HTTP port 80 connection, which is allowed to pass
        unhindered through the corporate firewall.

        An HTTP tunnel connection begins like a regular HTTP session,
        but instead of the GET method it uses CONNECT. For example:

                CONNECT g8pzt.ath.cx:23 HTTP/1.1

        Both host and port number must be present in the "URL" portion
        of the request.  The "host" portion may be either a hostname,
        or an IP address in dotted decimal form.

        If the request is denied because the destination is blocked by
        the security rules, the HTTP error message is "403 Forbidden",
        and the session terminates.

        If the request is allowed (see "security" below), the server
        attempts to connect to the specified host.  If successful, it
        then sends "200 Connection established" to the client,
        followed by a blank line.  The session then becomes fully
        transparent, and the HTTP server plays no further part in any
        transactions.  The streams are full 8-bit binary.


        Proxy / Tunnel Timeouts
        ~~~~~~~~~~~~~~~~~~~~~~~

        By default, 30 seconds is allowed for name resolution, and
        another 30 for the connection to establish.  This timeout may
        be altered using the PROXYTIMEOUT directive in HTTP.SYS (It
        may need to be more than 60 sec via radio channels).

        If the connection couldn't be established for any reason, the
        server sends a 5xx failure message, and the session terminates.


        Proxy / Tunnel Security
        ~~~~~~~~~~~~~~~~~~~~~~~

        If not configured correctly, the HTTP tunnel and proxy could
        pose a serious security risk, because they could allow users
        to access destinations behind your firewall.  In addition,
        they could be used to access an external destination via your
        IP address, thus hiding the identity of the caller.

        Therefore by default the proxy and tunnel are disabled.  In
        order to enable them you must configure some security...

        HTTP.ACL is the Egress Control file, i.e. it controls who the
        users of the proxy / tunnel are allowed to connect to.  If the
        file is not present, or there are no suitable entries in the
        file, the tunnel is blocked.

        It is suggested that egress control is configured such that
        "external" (i.e. Internet) users should only be allowed to
        connect to specific "internal" (i.e. intranet) destinations,
        such as the TELNET and CHAT servers, whilst intranet users may
        be allowed to connect to any destination.  See HTTP.ACL for
        details.

SEE ALSO
        HTTP.ACL(8) -- HTTP Proxy / Tunnel Egress Control File.
        HTTP.SYS(8) -- HTTP Proxy / Rewrite Rules.
        HTTP-SRV(9) -- HTTP Server.

HTTP-PROXY(9)               END OF DOCUMENT
