HTTP.SYS(8)             XROUTER REFERENCE MANUAL            17/10/2023

NAME
        HTTP.SYS -- HTTP Rewrite / Proxy Control File (Optional).

DESCRIPTION
        HTTP.SYS is an optional file. If present, it contains
        REWRITE rules for the HTTP server, and settings for the
        HTTP proxy server.

        URL rewriting modifies the URL's of incoming requests,
        according to a set of REWRITE rules. This can be used to
        organise widely-dispersed resources into a logical
        directory tree.

        The resources may be located on the same PC or even on
        different servers, but can be made to look as if they are
        all in the same tree on your server.  This is done by
        replacing parts of the requested URL with alternative
        strings of characters. 

        The PROXY commands configure XRouter's HTTP proxy to use a
        "downstream" proxy to reach certain IP address ranges.

FORMAT
        Each command or rule must be on a separate line, and may be
        up to 255 characters long. Lines beginning with ';' or '#'
        are ignored, and may be used for comments. Commands and
        rules are not case sensitive, and their fields must be
        separated by one or more spaces or tabs. Blank lines are
        ignored.

        The commands and rules are as follows:

            REWRITE <old_string> <new_string>
            PROXY <ipaddr> <port> <subnet_mask>
            PROXYTIMEOUT <secs>
 
        These are discussed in more detail below...

REWRITE
        The REWRITE rules have the following syntax:

            REWRITE <old_string> <new_string>

        <old_string> is a template which is compared with an equal
                     number of characters from the start of the
                     requested URL when an HTTP request is received.
                     The comparison is case-insensitive.

        <new string> is the character sequence which replaces
                     <old_string> if there is a match.  

        Example: REWRITE /bbs /systems/gb7pzt

        This would replace "/bbs" at the start of the URL with
        "/systems/gb7pzt". Thus a request for "/bbs/msgs.htm" would
        be rewritten to "/systems/gb7pzt/msgs.htm".

        There are no validity checks, so you must be careful not to
        inadvertently remove / characters from the rewritten string.
        e.g. the entry "rewrite /bbs/ http://192.168.0.4" would cause
        "/bbs/index.htm" to rewrite as "http://192.168.0.4index.htm",
        which will clearly fail.

        You can use rewriting to organise your resources into a neat,
        logical and compact directory tree, regardless of where they
        are actually located.

        <new_string> may also contain a URL, which invisibly invokes
        the HTTP proxy. For example:

            REWRITE  /bbs  http://192.168.0.4:85 

        This would replace "/bbs" at the start of the URL with
        "http://192.168.0.4:85", so that a URL like:
        /bbs/cgi-bin/menu.pz becomes:
        http://192.168.0.4:85/cgi-bin/menu.pz

        The resulting URL then treated as if it was a proxy request.

        When rewriting to proxy another system, the new URL must
        begin with "http://<address>[:port]" where <address> can be
        either a hostname or IP address.

        rewrite http://g8pzt.ath.cx/bbs   http://192.168.0.4 

PROXY
        The PROXY command allows XRouter's HTTP proxy to pass certain
        traffic to a downstream proxy. The format of the command is:

            PROXY <ipaddr> <port> <subnet_mask>

            e.g. "proxy 44.131.91.245  80  255.0.0.0"

        <ipaddr> is the IP address of the downstream proxy.

        <port> is the TCP port number of the downstream proxy.

        <subnet_mask> when combined with the proxy address specifies
                      the range of addresses which are on the same
                      subnet as the proxy.  These addressess will
                      bypass the proxy, i.e. XRouter's proxy will
                      connect directly to them instead of via the
                      next proxy.

        This kludge allows 44-net systems to use a further proxy to
        gain a public (Internet) IP address when connecting non-44
        websites. This is necessary because 44-net routing is
        unreliable at best, i.e. if a 44-net browser tries to
        connect directly to Google, the reply probably won't get
        routed back.

        For example, imagine a mobile station, consisting of a web
        browser and XRouter, with an IP/AX25 link to a nearby gateway,
        but no Internet connection. The IP address used over the
        radio link is 44.131.91.3.  The browser has been configured
        to use XRouter's HTTP proxy, which means the IP source address
        for all HTTP traffic from this station is 44.131.91.3.

        Via the nearby gateway, whose IP address is 44.131.91.245,
        the mobile station can happily browse 44-net (amprnet)
        websites. But when it tries to use Google, the replies
        aren't routed back.

        However, if the local gateway has been set up with the
        above PROXY command, the 44.x.x.x sites will be connected
        directly by the mobile XRouter's proxy, whilst the non-44
        sites will be passed to the gateway's HTTP proxy, where they
        will gain a 62.31.206.176 source address, which is reliably
        routable and doesn't rely on the co-operation of others in
        the amprnet.

        The PROXYTIMEOUT command specifies the maximum time in
        seconds to wait for a proxied connection.  If a connection
        takes longer than this to establish, an error is returned.

        The default is 30 secs, but may need to be longer on a
        slow radio channel.

FILES
       If required, HTTP.SYS must be located in the same
       directory as XRouter.EXE.

SEE ALSO
        HTTP.ACL(8) -- HTTP Proxy Egress Control File
        HTTPBAN.SYS(8) -- Blocks Malicious HTTP Requests

HTTP.SYS(8)                 END OF DOCUMENT
