;***********************|****** Max Width *****|*********************|
HTTPPORT(7)             XROUTER REFERENCE MANUAL             27/9/2023

NAME
        HTTPPORT -- TCP Port for HTTP Server.

SYNOPSIS
        HTTPPORT=n1 [n2] (where n1 and n2 are 0 to 65535)

DESCRIPTION
        HTTPPORT is an optional "global" directive used in
        XROUTER.CFG.

        If present, it specifies the TCP "service port" number used
        by the HTTP server. If not present, the default is 80.

        The HTTP server serves HTML files and provides a browser-
        -based user/sysop interface to XRouter.

        The server is also available via NetRomX service 80.

OPTIONS
        If a single argument is supplied, e.g. "HTTPPORT=80", it
        applies to whichever TCP/IP stack(s) XRouter is using.

        If TWO arguments are supplied, e.g. "HTTPPORT=80 8080", the
        first argument applies to the XRouter stack and the second to
        the host system's stack. The numbers must be separated by
        whitespace

        Setting HTTPPORT to zero on a stack prevents TCP connections
        to the HTTP server via that stack.

        See TCP-PORTS(6) for more information on this and the caveat
        below.

CAVEATS
        In order to use port numbers below 1024 on the Linux stack,
        XRouter must be run from a root account, or given the
        CAP_NET_BIND_SERVICE capability.

SEE ALSO
        CAPFLAGS(6)    -- Capability Flags.
        HTTP-SRV(9)    -- HTTP server.
        HTTP-SVC(9)    -- NetRomX HTTP Service.
        TCP-PORTS(6)   -- TCP Service Ports.
        XROUTER.CFG(8) -- Main Configuration File.

HTTPPORT(7)           END OF DOCUMENT
