IDS(9)                  XROUTER REFERENCE MANUAL            20/10/2023

NAME
        IDS -- Intrusion Detection System.

DESCRIPTION
        The purpose of XRouter's Intrusion Detection System (IDS) is
        to detect, repel and warn the sysop of, suspicious or
        malicious activities.

        It mainly operates on IP, where most of the threats arise,
        but also watches AX25 / Netrom. It does not need any setup
        and should not interfere with normal operation.

        The main indication of its presence is the "Security Monitor"
        window, which displays any detected threats. Other than that,
        there might be the occasional warning on the bottom right of
        the "overview" window.


        Security Monitor Window
        ~~~~~~~~~~~~~~~~~~~~~~~

        Positioned between the "Overview" window and the "Consoles",
        the "Security Monitor" is intended to remind / inform you of
        any suspicious actitvity.

        In most cases, this is just a waste of a window, showing all
        zeros and mostly empty space. That's a good thing - it shows
        you are (probably) safe.
 
        However if you have any IP services enabled, the window might
        come alive with activity. The top section shows an overview
        of the threat statistics, whilst the rest of the window shows
        the latest warning messages, in various colours according to
        the severity of the threat.

        There are 4 notification Levels as follows:

            1 - IMPORTANT!:  Intrusion / Escalation attempts (cerise)
            2 - WARNING:     Recon attempts (port scans etc (red)
            3 - ADVISORY:    Possible suspicious events (yellow)
            4 - INFORMATIVE: Unusual events (white)

        You can change which notifications are displayed using the
        following command:

            IDS V[erbosity] [level]

        [level] is 0 (no notifications) to 4 (all notifications).

        For example the command "IDS V 2" enables intrusion and recon
        notifications only.

        Pressing <F1> on the IDS window displays a pop-up box with
        the notification levels, a brief description of the stats,
        and a reminder of the IDS commands.

        The various statistics displayed in the upper pane are
        described in the section "IDS Statistics" below.


        IDS Logging
        ~~~~~~~~~~~

        The IDS notifications pane only has limited space, and you
        can't watch it all the time, which is where IDS logging comes
        in handy. 

        IDS events can be logged, either by enabling the IDS option
        in the LOG directive, or by using the command "IDS LOG ON".

        if IDS logging is enabled, some (but not all) IDS events are
        logged to the file LOG/YYMMDD_IDS.LOG, where YYMMDD are the
        2 digit year, month and day of the month.

        Log entries are usually of the form:

           <time> <source_IP> -> <dest_IP>[:port] <description>

        For example:

        15:11:12 192.168.0.135 -> 192.168.0.101:137 Unsolicited UDP
        20:16:02 192.168.0.135 -> 192.168.0.101:443 TCP SYN - refused
        21:04:57 44.197.188.109 -> 44.135.49.90:443 TCP SYN - refused

        The last entry reveals a threat from the section of 44-net
        that was sold off to commercial interests, and the need to
        update the IP access Control List entries to block this
        section of the 44/8 address space.


        IP Banning
        ~~~~~~~~~~

        One part of XRouter's defences is "IP banning".

        If XRouter detects malicious activity on its own TCP/IP
        stack, it will "ban" the originator's IP address. This means
        that any further packets from that IP address are ignored,
        for as long as the ban lasts.

        If malicious activity is detected on any Linux TCP or UDP
        port that is currently used by XRouter, that also causes
        a ban. In this case, TCP connections are terminated, and any
        further connections or UDP frames are ignored.

        There is no time limit on IP bans, and they are preserved
        across reboots. Up to 200 IP addresses can be banned at once.

        A larger table would become unwieldy, so when a new address
        is added, the oldest one is dropped. In practice this isn't
        usually a problem because the oldest aggressor has usually
        given up long ago, and is unlikely to come back.

        IP bans can be added manually using the IP BAN ADD command,
        the format of which is:

                IP B[an] A[dd] <ipaddr> [netmask]

        For example:

                ip ban add 44.197.188.109
                ip ban add 44.128.0.0  255.192.0.0

        They can also be removed using "IP U[nban] <ipaddr>".

        The ban list can be displayed using "IP B[an] L[ist]"

       
        Port Scanners
        ~~~~~~~~~~~~~

        Scans are not necessarily dangerous, although in some cases
        they may consume substantial resources. The main issue with
        scans is that are usually a prelude to an attack. Once your
        presence has been detected by a scan, the hackbots tend to
        inform each other and launch an attack. It may not happen
        immediately, but it will usually happen.

        If you have any TCP/IP services open to the Internet, for
        example Telnet or even AXUDP, scans are inevitable. The IDS
        warns you, so you can take evasive action, such as IP and 
        TCP / UDP ingress filtering, and allows you to test its
        efficacy. It also disrupts the scanning process, causing the
        hackbots to time out and move on. 

        A word of warning: If you scan your own system, you might
        suddenly find that you can no longer access XRouter from
        the machine that performed the scan because its IP has been
        banned. If you can access XRouter from its own console, or
        via a machine that hasn't been IP-banned, you can use the IP
        UNBAN command to remove the banned address.


        Honeypots
        ~~~~~~~~~

        In this context, a honeypot a sticky trap, set up on popular
        TCP or UDP ports, for catching internet low-life.

        Hackbots generally start their attacks by probing for open
        TCP ports, and to save time they often start with the most
        popular ones - telnet, SSH, HTTP, VNC and so on. If they find
        an open port, they tend to inform each other, then they all
        concentrate their attacks on that port.

        Unless you have a particular service port open, the chances
        are that anyone who tries to connect to it is up to no good.
        So the honeypot is a mitigation measure. It LOOKS like an
        attractive open port, but it's not! Anyone who connects to it
        gets their IP address logged and banned. After that they
        can't do any more attacking unless they change their IP
        address.

        It's not foolproof. Nation states have access to large
        numbers of IP addresses. But IP banning slows them down,
        and the IDS alerts you that there is a problem.


        Setting Up a Honeypot
        ~~~~~~~~~~~~~~~~~~~~~

        IP sub-commands BAN PORT ADD, BAN PORT DROP, BAN PORT LIST,
        and BAN PORT SAVE allow management of the "honeypot" ports.

        A honeypot is created using the following command:

              IP B[an] P[ort] A[dd] <TCP|UDP|ALL> <start> [end]

        <TCP|UDP|ALL> - protocol(s) to catch.
        <start>       - single port, or the start of a range.
        [end]         - last port in a range.

        For example: "ip ban port add tcp 443" sets up a honeypot
        which IP bans anyone who tries to cpnnect to TCP port 443.

        Similarly "ip ban port add tcp 5900 5999" creates a honeypot
        covering the TCP port range commonly probed for VNC.

        Honeypots and their stats can be displayed using:

              IP B[an] P[ort] L[ist]

        They can be saved (to IPBAN.SYS) using:

              IP B[an] P[ort] S[ave]

        And they can be removed using:

              IP B[an] P[ort] D[rop] <TCP|UDP|ALL> <start> <end>

        Note that both the start and end ports are mandatory in the
        DROP command. For single ports, both numbers are the same.


        IDS Statistics
        ~~~~~~~~~~~~~~

        If you have access to XRouter's display, the top section of
        the "Security Monitor" window gives you some statistics.

        If you have "sysop" access to XRouter you can also view more
        comprehensive stats using either the "S[tats] IDS" or the
        "IDS S[tats]" commands, both of which display the same data,
        something like this: 

            IDS Events:       25778   Cmd Overflow:     0
            FTP DIR Hacks:    0       IP Addr Heard:    100
            IP Addr Banned:   200     IP Banned Total:  183     
            IP Dgram Blocked: 2076    ICMP Frm Blocked: 32
            Honeypot Hits:    0       UDP Segs Ignored: 3251968
            UDP Segs Blocked: 22      TCP Segs Ignored: 9967
            TCP Segs Blocked: 2022    TCP Conn Blocked: 763     
            Bogus SYNs:       15776   Smurf Attacks:    0
            Fraggle Attacks:  0       IP Frag Attacks:  0
                      (Tiny=0  Huge=0  Overlapped=0)
            TCP Scans: SYN=1 FIN=0 ACK=57 NUL=0 MAI=82 XMS=0 OTH=9600
            Rejected Logins:  763 (Telnet=763, Rlogin=0, FTP=0,
               TelProxy=0)
            Malicious Logins: 182 (Telnet=182, Rlogin=0, FTP=0,
               TelProxy=0)
            HTTP No-Request:  0       HTTP Bad Request: 0
            HTTP Blocked:     0

        "IDS Events" is the total number of times the IDS has noticed
                something suspicious.

        "Cmd Overflow" is the number of times that someone has
                attempted a buffer overflow attack.

        "FTP DIR Hacks" is the number of attempts to escape from the
                FTP root directory.

        "IP Addr Heard" is the number of unique IP addresses heard.

        "IP Addr Banned" is the number of IP addresses in the "banned
                IP" table. As the table is saved across reboots, it
                is normal for it to be full.

        "IP Banned Total" is the number of new IP addresses banned
                since bootup. This figure may exceed the table size
                because new bans replace stale ones.

        "IP Dgram Blocked" is the number of IP datagrams blocked
                because the sender's IP address was in the banned IP
                table.

        "ICMP Frm Blocked" is the number of ICMP frames blocked
                because the sender's IP address was in the banned IP
                table.

        "Honeypot Hits" is the number of times someone attempted to
                access one of the "honeypot" ports. These are traps
                which lure port scanners into an IP ban.

        "UDP Segs Ignored" is the number of UDP segments ignored
                because there was no matching socket to receive them.

        "UDP Segs Blocked" is the number of UDP segments blocked
                because the sender's IP address was on the banned IP
                list.

        "TCP Segs Ignored" is the number of TP segments ignored
                because there was no matching listener socket.

        "TCP Conn Blocked" is the number of TCP connection attempts
                blocked because the sender was on the banned IP list.

        "Bogus SYNs" is the number of TCP connection attempts blocked
                because the SYN was malformed or maliciously crafted.

        "Smurf Attacks" are distributed denial of service attacks
                which use ICMP directed at broadcast addresses.

        "Fraggle Attacks" are variations of Smurf attacks, where the
                attacker sends lots of traffic to UDP ports 7 (Echo)
                and 19 (CHARGEN)

        "IP Frag Attacks" is the number of IP fragmentation attacks.
                These attacks attempt to overwhelm or crash the IP
                fragment reassembly mechanism.
                Tiny - First fragment is too short to contain valid
                       TCP+IP headers, so it could bypass port-number
                       filtering.
                Huge - Fragment exceeds maximum datagram size.
                Overlapped - Fragments which overlap but don't align.

        "TCP Scans" is the number of TCP port scans detected and
                blocked. Totals for each scan type are shown
                separately:

                SYN - Scanner sends SYN but never completes the 3 way
                      TCP handshake.
                FIN - TCP segments with only the FIN bit
                ACK - Only the ACK flag is set
                NUL - NULL scan (no flags are set)
                MAI - Maimon scan (FIN and ACK flags set)
                XMS - Xmas Tree scan (FIN, PSH and URG flags set)
                OTH - Other types of scan
 
        "Rejected Logins" are Telnet / FTP etc logins which were
                rejected because the source IP was banned or the
                login credentials were incorrect.

        "Malicious Logins" are TCP logins attempted using suspicious
                or common attack credentials.

        "HTTP No-Request" is the number of connections to XRouter's
                HTTP server which didn't contain an HTTP request.
                These are usually the result of port scanning.

        "HTTP Bad Request" is the number of malformed or maliciously
                crafted HTTP requests. These are usually attempts to
                exploit vulnerabilities in certain types of HTTP
                server or operating system.

        "HTTP Blocked" is the number of HTTP server connections
                refused because the sender's IP was in the blocked
                IP list.


        IDS-Related Commands
        ~~~~~~~~~~~~~~~~~~~~

        IDS L[og] [on | off]
        IDS S[tats]
        IDS V[erbosity] [0-4]
        IP B[an] A[dd] <ipaddr> [netmask]
        IP B[an] D[rop] <ipaddr>
        IP B[an] L[ist]
        IP B[an] P[ort] A[dd] <TCP|UDP|ALL> <start> [end]
        IP B[an] P[ort] D[rop] <TCP|UDP|ALL> <start> <end>
        IP B[an] P[ort] L[ist]
        IP B[an] P[ort] S[ave]
        IP B[an] S[ave]
        IP Q[uiet] [level]
        IP U[nban] <ipaddr>
        S[tats] IDS

CAVEATS
        The IDS is not set in stone. It evolves and morphs as the
        threatscape changes. Therefore some of the above may be out
        of date already.

        Nor does it claim to be a 100% foolproof system. XRouter's
        primary purpose is for Amateur Packet Radio, not Internet
        defence! The IDS must strike a balance between defending the
        system, informing (but not overwhelming) the sysop, and not
        getting in the way of normal operations.

SEE ALSO
        IDS(1)         -- Intrusion Detection System Commands.
        IP(1)          -- IP-related Commands.
        ACL(1)         -- IP Access Control List Commands.
        LOG(7)         -- Activity logging options
        ACCESS.SYS(8)  -- Telnet Access Control File.
        IPBAN.SYS(8)   -- Banned IP addresses File.
        XROUTER.CFG(8) -- Main Configuration File.
        AXSCTRL(9)     -- TCP/IP Access Control.

IDS(9)                      END OF DOCUMENT
