;*************************** Max Width *******************************
IDTEXT(7)             XROUTER REFERENCE MANUAL               24/9/2023

NAME
        IDTEXT -- Identification Text.

SYNOPSIS
        IDTEXT        }
        <text>        } "global" idtext
        ***           }
        IDTEXT=<text>    <-- "port" idtext

DESCRIPTION
        IDTEXT is a configuration directive that can be used both
        "globally" and within PORT definition blocks in XROUTER.CFG.

        It specifies a single line of text to be broadcast via AX25
        every IDINTERVAL, to a destination path specified by IDPATH.

        If used within the "global" section of XROUTER.CFG, the value
        is "inherited" by any PORTs defined further down, UNLESS
        there is an IDTEXT in that PORT block.

        If used in a PORT block, IDTEXT overrides the "global" value,
        on that port only. 

        The <text> is specified differently for the global and port
        cases. In the global case, IDTEXT begins a 3 line block,
        with <text> on the second line and "***" on the third line,
        which is a BPQ legacy. In a PORT block, <text> is specified
        using a single line.

        Only one line of text (248 characters max.) may be specified.

        The text may be changed during run-time using the IDTEXT
        command.

NOTE
        If the global <text> includes and APRS-format static position
        code, starting within the first 40 characters, XRouter will
        be visible on APRS maps and the MHeard function will record
        distances to heard stations, if they are broadcasting their
        positions. The position code format is "!ddmm.mmN/dddmm.mmE"
        where dd represents degrees of latitude or longitude and
        mm.mm represents minutes to two decimal places. "N" and "E"
        may be replaced by "S" and "W" as appropriate. It is highly
        recommended that you include your position,

EXAMPLE
        IDTEXT=!5224.00N/00215.00W# (Kidder)

SEE ALSO
        IDINTERVAL(7)  -- Identification Beacon Interval
        IDPATH(7)      -- Identification Beacon Path
        IDTEXT(1)      -- Display / Set Identification Beacon
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

IDTEXT(7)                  END OF DOCUMENT
