IDTEXT(1)             XROUTER REFERENCE MANUAL               24/9/2023

COMMAND
        IDTEXT -- Display / Set ID Beacon Text.

SYNOPSIS
        IDT[ext] <port | 0> [text]

AVAILABILITY
        Sysop only.

DESCRIPTION
        Displays or modifies the contents of the regular AX25 "ID"
        beacons, which are transmitted every IDINTERVAL.

        The "port" argument is either a valid port number, or zero.
        In the latter case the command displays or sets the "global"
        IDTEXT.

        If "text" is not specified, the current IDTEXT for the
        specified port is displayed.

        If "text" is specified, the IDTEXT parameter for the specified
        port is changed to the new value.

        The minimum abbreviation of this command is IDT.

EXAMPLES
        IDT 0 !5220.00N/00102.13W Miltown Node.  - Set global IDTEXT
        IDT 3                   - Display current IDTEXT for port 3
        IDP 3 Test only         - Override global IDTEXT on port 3

LIMITATIONS
        The IDTEXT must be a single line only.

        Since the command line is limited to 80 characters, the
        maximum length of IDTEXT that can be entered using this
        command is 74 characters (IDTEXTs that exceed 74 characters
        can only be specified in XROUTER.CFG).

SEE ALSO
        IDINTERVAL(7)  -- Identification Beacon Interval
        IDPATH(1)      -- Display / Set Identification Beacon
        IDTEXT(7)      -- Identifation Text Directive
        XROUTER.CFG(8) -- Main Configuration File.

IDTEXT(1)                        END OF DOCUMENT
