IFACE(1)               XROUTER REFERENCE MANUAL               8/9/2023

COMMAND
        IFACE -- Description..

SYNOPSIS
        IF[ace] A[dd] <ifacenum> <type> <mtu> [id]
        IF[ace] D[isplay] <ifacenum> | all
        IF[ace] DR[op] <ifacenum>
        IF[ace] L[ist]
        IF[ace] STA[rt] <ifacenum> 
        IF[ace] STO[p] <ifacenum>
        IF[ace] <ifacenum> <command> [args]

AVAILABILITY
        Sysop-only.

DESCRIPTION
        The IFACE command can be used to add, modify, remove, list,
        start and stop XRouter's interfaces on the fly.

WARNING
        This is a bit buggy at present. Not all of the commands work
        properly for all types of interface. Stopping some types of
        interface can cause XRouter to crash!!

OPTIONS
        The A[dd] sub-command is used to create a new interface:

              IF[ace] A[dd] <ifacenum> <type> <mtu> [id]

              <ifacenum>  Number to assign to the interface.
              <type>      Interface type (see below)
              <mtu>       Maximum Transmission Unit
              [id]        Optional name for the interface

        Interface types (there are others):

              AGW          AGW Packet Engine
              ASYNC        Serial (COM) port
              AXIP         AX25 over IP
              AXTCP        AX25 over TCP
              AXUDP        AX25 over UDP
              EXTERNAL     External (eg Ethernet)
              LOOPBACK     Internal loopback (don't use!)
              TCP          Anything over TCP
              TUN          Linux "tunnel" (tun) interface
              UDP          Anything over UDP
              YAM          YAM 1200/2400/9600 modem

        For example, to create interface 3 (providing iface 3 doesn't
        already exist), type AXIP:

              iface add 3 axip 256 My new interface

        The DR[op] sub-command deletes an interface, for example:

              IFACE DROP 3

       The L[ist] sub-command lists the interfaces, showing their
       numbers, types, rotocols, MTU's and descriptions:

              IFACE LIST 

              G8PZT:KIDDER} Interfaces:

              Num Type     Prtcl    MTU  Description
                1 external ether    1064 eth0
                2 axudp    axudp     256 
                3 axtcp    axtcp     340 
              (End of list)

        The D[isplay] sub-command displays the details of a single
        interface:

              iface d 1

              G8PZT:KIDDER} Interface 1: 
                  Type=external, Ptcl=ether, MTU=1064, Descr=eth0
                  Used by port(s):  1
                  MAC Address=B8:27:EB:35:5C:5B

        If the argumemt is "ALL" instead of a specific number, all
        the interfaces are listed in detail.

        The STA[rt] sub-command is used to bring an interface into
        use, e.g.:

              IFACE START 2

        The STO[p] sub-command takes an interface out of use, for
        example:

              IFACE STOP 2

        You cannot stop an interface which has dependent ports until
        all those ports have first been stopped. At present,
        stopping an Ethernet interface may cause a segfault.

        Certain interface parameters can be changed on the fly,
        using the general command form:

              IF[ace] <number> <command> [args]

              e.g. IFACE 4 ID Paula's Interface
 
        The following parameters are accepted so far, but as this is
        a work in progress, they are not all fully functional...

              COM CONFIG FLOW ID INTNUM IOADDR KISSOPTIONS MTU
              NUMBER PROTOCOL SPEED TYPE

        (CONFIG, PROTOCOL and MTU are not yet working)

SEE ALSO
       PORTS(1)       -- Port management commands
       XROUTER.CFG(8) -- Main configuration file.

IFACE(1)                  END OF DOCUMENT
