;*************************** Max Width *******************************
IFACES(6)              XROUTER REFERENCE MANUAL              23/9/2023

NAME
        IFACES -- Interfaces in XRouter.

DESCRIPTION
        An XRouter INTERFACE is a physical (e.g. a COM port) or
        virtual point of connection between XRouter and somewhere
        else. The "somewhere else" is usually the world outside the
        PC, but it may also be an internal connection to other
        applications on the same PC.

        This is not to be confused with Linux interfaces, which exist
        at a lower level, within the Linux kernal.

        Apart from the keyboard input, the screen output, and the
        internal connection with Linux's TCP/IP services, everything
        that enters or leaves XRouter must ultimately pass through an
        INTERFACE.

        Some types of interface support only a single "channel" of
        data, whilst others can support multiple channels, either
        due to their physical construction, or the protocol used.

        Interfaces usually have one or more PORTS "attached" to them.
        A PORT is the point of interaction between the various
        protocol modules and *one channel* of an interface.

        However some interfaces, such as those used by XRouter to
        emulate other types of hardware or software, do not support
        ports. An example of this latter type would be the TNC2
        interface.

        Defining Interfaces in XRouter
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        XRouter interfaces are configured using INTERFACE definition
        blocks within XROUTER.CFG.

        The interface definition block must reside in the GLOBAL
        section of XROUTER.CFG, i.e. you cannot define an interface
        within any other block.

        The block starts with the directive "INTERFACE=n", where n is
        a unique number used to identify the interface. The actual
        number is unimportant, as long as it is greater than zero and
        no other interface uses the same number. The block ends with
        ENDINTERFACE.

        The block must contain at least the TYPE and MTU directives,
        otherwise XRouter will refuse to start. Additional directives
        may be required, depending on the TYPE. The full range of
        interface keywords is summarised in OPTIONS below

OPTIONS
        Interface Keywords - Overview: (*=mandatory)
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        APPLNUM         Application number (DEDHOST only)
        CHANNEL         Channel on multi-channel hardware
        CHANNELS        No. of TNC channels (DEDHOST only)
        COM             Usually the hardware device name
        CONFIG          Hardware-specfic config options
        ENDINTERFACE  * Ends interface definition block
        ETHADDR         Ethernet address (NdisXpkt only)
        FLOW            Flow control options (async only)
        ID              Interface identification string
        INTNUM          Was interrupt number, now multi-purpose
        IOADDR          Was I/O address, now multi-purpose
        KISSOPTIONS     Options for KISS interfaces only
        MTU           * Maximum Transmission Unit
        PROTOCOL        Protocol used on this interface
        RADIO           Radio controlled by this interface
        SPEED           Serial (async) or RF (SCC) baud rate
        TYPE          * Type of hardware

        Interface Keywords - Detail
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~

        APPLNUM
          Application number (WA8DED hostmode interfaces only).
          Specifies which application will be using this interface.
          Must match the number in the corresponding APPL block.
 
        CHANNEL
          Channel on multi-channel hardware (e.g. SCC cards). XRouter
          does not currently support SCC cards on Linux, so this
          keyword should not be used.
 
        CHANNELS
          For WA8DED hostmode interfaces only. Specifies the max no.
          of host channels (between 1 and 32) the interface will
          provide.
 
        COM
          This is mandatory for some interfaces only. For ASYNC and
          YAM types, it specifies the name of the serial
          communication device, e.g. "/dev/ttyUSB0". For the TUN
          interface it specifies an optional tunnel name, for example
          "tun99". For a UDP interface it specifies the remote end's
          UDP port. Setting COM=0 can be used to "park" an interface.
 
        CONFIG
          Hardware-specific config options. The format depends on the
          interface type.  Can be used to switch real TNC into KISS
          mode at startup for example.
 
        ENDINTERFACE (mandatory)
          Marks the end of the INTERFACE definition block. Subsequent
          keywords will be treated as GLOBAL. 

        ETHADDR
          (Not currently used in XRouter and might be removed)
          Ethernet address in form xx:xx:xx:xx:xx:xx. Was used in
          XR32 only for EXTERNAL drivers using ETHER protocol, such
          as the NdisXpkt driver. 

        FLOW
          Flow control options (ASYNC interfaces only):

            0 = No flow control
            1 = Hardware (RTS/CTS) flow control
            2 = Software (XON/XOFF) flow control (TTY link only)
            3 = Hardware AND software flow control

          If not specified, flow control defaults to NONE. Don't use
          Xon/Xoff with KISS. 

        ID
          Interface Identification. This is a plain text string which
          identifies the interface on various displays. Keep it
          concise, e.g "Ethernet". 20 characters max.
 
        INTNUM
          Used by AGW, AXTCP, TCP, and UDP interfaces. For the AXTCP
          and TCP servers, this specifies the TCP port the server
          should listen on. For UDP interfaces it specifies the local
          UDP port. For the AGW interface it specifies the TCP port
          used to connect with the AGW Packet Engine.

          (This is a recycled keyword, which was used in XR16 to
          specify a hardware interrupt number). 

        IOADDR
          For AGW interfaces, this specifies the IP address of the
          AGW packet Engine (or Direwolf etc). If not specified, it
          defaults to 127.0.0.1 (localhost). Not currently used
          anywhere else.

          (This is another recycled keyword, which was used in XR16
          to specify an hardware IO address.) 

        KISSOPTIONS
          Options for KISS interfaces only:

            NONE     - Plain KISS (most TNC's use this) (default)

            POLLED   - For TNCs which send only when polled.

            CHECKSUM - Packets are protected by checksum.  You can
                       only use this option if your TNC supports it.

            ACKMODE  - For TNC's which inform XRouter when a
                       frame has been transmitted on air.

            SLAVE    - XRouter will act like a polled KISS TNC,
                       sending only when commanded to do so.

            NOPARMS  - Don't send TNC configuration parameters.

          POLLED and SLAVE are mutually exclusive. BPQKISS eproms
          require POLLED and CHECKSUM, but their use of ACKMODE is
          optional.
 
        MTU (mandatory)
          Maximum Transmission Unit. This specifies the maximum size
          for the data portion of a packet transmitted on the
          interface.

          IP datagrams are sized or fragmented according to the MTU
          of the interface on which they are transmitted.

          XRouter allows MTU's up to 1500 bytes, but setting MTU
          above 256 is not recommended on AX25 ports, because the
          buffer size on TNC-based nodes is usually only big enough
          for a 256-byte data field.

          This is a mandatory keyword, although for some interface
          types the value has no meaning and is ignored. If in doubt,
          use 256.
 
        PROTOCOL
          Protocol to use on the interface:

            ASCII    - Remote consoles (TTY) via ASYNC ports
            AX25     - Pure ax25, no CRC or HDLC
            AXIP     - AX25 over IP (with CRC)
            AXTCP    - AX25 over TCP/IP (with CRC)
            AXUDP    - AX25 over UDP/IP (with CRC)
            DEDHOST  - DEDHOST emulation
            ETHER    - Ethernet
            HDLC     - For use with YAM modem, and some EXTERNAL
                       drivers.
            IP       - Internet Protocol, may be used on TCP,
                       UDP,  TUN and LOOPBACK interfaces.
            KISS     - For driving KISS TNCs or wired links.
            MODEM    - Hayes compatible PSTN modem.
            NETROM   - Netrom backend serial link.
            NONE     - Use this with type=loopback
            PPP      - Point to Point Protocol
            SLIP     - Serial Line Internet Protocol 
            TNC      - External TNC/device in normal cmd mode
            TNC2     - TNC2 emulation.

            (see PROTOCOL(7) for more detail)

        RADIO
          Number of the radio (if any) controlled by this interface.
          Required only if rig control is needed.

        SPEED
          The serial port baud rate for ASYNC interfaces only. Don't
          include a comma.
 
        TYPE (mandatory)
          Interface type as follows:

            AGW            AGW Packet Engine
            ASYNC          Serial (e.g. RS232)
            AXIP           AX25 over IP
            AXTCP          AX25 over TCP
            AXUDP          AX25 over UDP
            EXTERNAL       External driver
            LOOPBACK       Internal loopback
            TCP            TCP pseudo-interface
            TUN            Linux "tunnel" (tun) interface
            UDP            UDP pseudo-interface
            YAM            YAM 1200/2400/9600 modem


EXAMPLES
        KISS TNC on USB to RS232:
        ~~~~~~~~~~~~~~~~~~~~~~~~~

          INTERFACE=1
              TYPE=ASYNC
              COM=/dev/ttyUSB1
              SPEED=9600
              PROTOCOL=KISS
              KISSOPTIONS=POLLED,CHECKSUM,ACKMODE
              MTU=256
          ENDINTERFACE

        Ethernet:
        ~~~~~~~~

          INTERFACE=2
              TYPE=EXTERNAL
              ID=/dev/eth0
              PROTOCOL=ETHER
              MTU=1064
          ENDINTERFACE

        AXUDP Interface:
        ~~~~~~~~~~~~~~~

          INTERFACE=9
              TYPE=AXUDP
              MTU=256
          ENDINTERFACE

SEE ALSO
        AGW-IFACE(6)    -- AGW Interface.
        ASYNC-IFACE(6)  -- ASYNC (serial) Interface.
        AXIP-IFACE(6)   -- AX25 over IP Interface.
        AXTCP-IFACE(6)  -- AX25 over TCP Interface.
        AXUDP-IFACE(6)  -- AX25 over UDP Interface.
        EXTERN-IFACE(6) -- External / Ethernet Interface
        LOOP-IFACE(6)   -- Loopback Interface.
        PORTS(6)        -- PORTS in XRouter.
        PROTOCOL(7)     -- Protocol Used on INTERFACE.
        TCP-IFACE(6)    -- TCP Interface.
        TUN-IFACE(6)    -- Tunnel Interface.
        UDP-IFACE(6)    -- UDP interface.
        XROUTER.CFG(8)  -- Main Configuration File

IFACES(6)                  END OF DOCUMENT
