IGATE(9)                XROUTER REFERENCE MANUAL            16/10/2023

NAME
        IGATE -- APRS Internet Gateway.

DESCRIPTION
        XRouter has an inbuilt APRS Igate, which allows received APRS
        packets to be gated to an Internet APRS server, and packets
        from the server to be gated to RF.  You will need an APRS port
        and an internet connection to take advantage of this.

        Igate operation is controlled mainly by configuration settings
        in file IGATE.CFG.  If the file isn't present, the igate
        daemon can be started, but nothing will happen.  The file
        includes keywords which specify the Internet APRS server
        addresses, various timers controlling connections, the
        filtering rules for gating packets, and the logging options.

        In addition to the settings in IGATE.CFG there are a few in
        XROUTER.CFG, which control whether or not the Igate daemon
        starts at boot-up, and which ports may send to and receive
        from the Internet.


        Choosing and specifying Internet Servers
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        The choice of server, and the TCP port to use on that server,
        depends on where in the world you are located, and what sort
        of data you're interested in.  There are several types of
        server, and the services they provide aren't always
        comparable.

        Some servers provide a "raw" data feed containing APRS
        activity from all over the world, which can amount to a
        considerable volume.  Some also provide "filtered" or "local"
        feeds, e.g. Ohio-only or messages-only.

        There's no point in connecting to a "raw" feed if there is a
        "local" feed available, as you will merely be wasting CPU
        time and internet bandwidth downloading data you are going to
        discard.  APRS message-only feeds tend to be on port 1314,
        whereas "raw" feeds tend to be on port 10151, or 2023 if
        it's a Ahub server.

        Using a browser to connect to http://server_address:14501
        sometimes  produces a status page containing useful server
        addresses. You could start your search at "first.aprs.net".

        In IGATE.CFG you may specify as many servers as you wish, each
        on a separate line with the following format:

               SERVER <ipaddress | hostname>:<port>

               e.g. SERVER 128.196.58.1:1314

        The port number must be separated from the IP address or
        hostname by a colon so that the combined address:port forms a
        contiguous string of characters with no spaces.

        The servers are tried in rotation, starting with the first on
        the list. If a connection attempt fails, or the link
        subsequently closes, the next server is tried.  When the end
        of the list is reached it starts all over again at the first
        one.  The behaviour is modified by various timer settings
        - see below.

        You may find out which server is currently in use by using the
        "TCP STATUS" command.


        Connection Timers
        ~~~~~~~~~~~~~~~~~

        There are various keywords which may be used in IGATE.CFG to
        control the timings associated with connections to the
        Internet servers, and they are as follows:

        WAIT <secs> -- Time to wait for connection establishment.

            Specifies the number of seconds to wait for connection
            after sending a connect request.  If not specified, the
            default is 60.  
            If you have a permanent Internet connection, you may wish
            to set a lower value, but if you're using dialup you may
            wish to make it longer, e.g. 90 secs to allow time for
            dialling and modem negotiation.  If no response is
            received from the server within the WAIT interval, the
            next server in the SERVER list will be tried.

        PAUSE <secs> -- Interval between successive tries.

            Specifies the number of seconds to wait between successive
            connection attempts to the same server.  Default is 60
            secs.

            If a server goes down or fails to respond, there's no
            point in aggressively trying to connect. For one thing,
            if you have connection logging enabled you will build a
            big logfile!  This timer is mainly of use when you have
            only one server in you SERVERS list, or when several
            servers go down.

        MAXTRIES <n> -- No. of failed connect attempts allowed.

            If a server consistently fails to respond to connect
            attempts, there's a good chance it has gone temporarily or
            permanently off line.  The MAXTRIES value specifies the
            maximum number of failed connect attempts allowed before a
            server is ignored, and the default is 10.  If the limit is
            reached, that particular server will not be retried until
            the SKIP interval (see below) expires.

        SKIP <secs> -- "Blacklist" interval.

            Specifies the amount of time for which a server will not
            be tried after MAXTRIES failed connect attempts.  This
            effectively removes a server from the list for the SKIP
            interval, after which it is placed back on the list.
            Default is 3600 secs (1 hour).


        Packet Filtering
        ~~~~~~~~~~~~~~~~

        The Igate contains powerful packet filters, which can be
        applied to traffic gated in both directions.  The filtering
        rules are specified in IGATE.CFG using IFILTER (internet to
        packet) and PFILTER (Packet to internet) statements, the
        general form of which are as follows:

               xFILTER <from_call> <to_call> <text>

        Each field may include the following wildcards:

               *     Matches zero or more characters.
               ?     Matches any single character.
               #     Matches a single digit.
               @     Matches a single alphabetic character.
               \     Escape - interpret next character literally.

            The '*' character may only be used at the end of a field.

        For example:  "IFILTER G#@@@*  *  :*" will accept from the
        internet feed only those packets sent by valid G0 to G9 + 3
        letter callsigns, addressed to anyone, which contain APRS
        messages.

        The '\' (escape) character causes the next character to be
        interpreted literally, instead of as a wildcard, e.g. "\*"
        will match '*' and "\\" will match '\'.

        A caret '^' at the start of any field will invert the sense of
        the whole test, causing matching packets to be REJECTED, e.g. 

               IFILTER ^M7ABC  *    *
               IFILTER *       ^APZ244*   !*

        The first statement will reject all packets from M7ABC, and
        the second will reject all static position reports sent to the
        destination APZ244 (e.g. if they can't be trusted).  Rejection
        statements MUST be placed at the beginning of the filter
        rules, before any catch-alls.

        The maximum length of each field (pattern) is currently 10
        characters.  There is no limit to the number of xFILTER
        statements you may specify.  If no rules are specified,
        nothing will be gated.

        All valid APRS and UI-View packets (except 3rd party packets,
        and those with NOGATE or RFONLY somewhere in the digi path)
        received by the router are offered to the PFILTER, providing
        the appropriate DIGIFLAGS are set (see below). Mic-E packets
        are decoded to text before being offered to the Internet
        servers because they may contain characters which won't pass
        through the servers.  This decoding takes place before
        filtering.

        You should be VERY careful when designing your filter rules,
        as you could quite easily overload the RF channel by
        attempting to gate too much data to it.  There is little point
        in gating non-local data.

        To reduce unnecessary traffic, APRS "messages" are only gated
        to RF if the recipient has been seen locally on RF within the
        last hour.


        Radius of Interest
        ~~~~~~~~~~~~~~~~~~

        In IGATE.CFG the statement "RADIUS <km>" sets a radius in
        Kilometres from XRouter's position.  Position reports from
        within this radius are gated to RF, providing they pass the
        IFILTER rules.  The default radius is 100Km.  Setting
        "RADIUS 0" allows unlimited gating of positions.


        Controlling gating direction / port(s)
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Regardless of any other settings, an XRouter port will not
        broadcast packets received from the Internet, or offer
        received packets to the internet, unless the appropriate bits
        are set in the port DIGIFLAG. You should add one or both of
        the following values to DIGIFLAG:

            Bit Value Option
            ------------------------------------------------
             6   64   Enable gating from Packet to Internet.
             7  128   Enable gating from Internet to Packet.

        Packets accepted (i.e. passing IFILTER) from the Internet are
        broadcast on ALL ports which have bit 7 of DIGIFLAG set, so be
        careful not to lazily set DIGIFLAG to 255!


        Activity logging
        ~~~~~~~~~~~~~~~~

        Igate activity can be recorded in the file ./LOG/IGATE.LOG by
        including a LOG keyword with non zero argument in IGATE.CFG.
        The argument is a number made up as follows:

            Bit Value Option
            ------------------------------------------------
             0    1   Record Igate daemon start and stop events.
             1    2   Record Inet server connections / disconnections.
             2    4   Record frames sent from Internet to Packet.
             3    8   Record frames sent from Packet to Internet.

        The "record frames" options can generate a lot of data, so
        they're intended mainly for testing purposes, e.g. making sure
        your filters are correctly set.  To avoid the logfile growing
        too big, you are advised to periodically rename or otherwise
        remove it, allowing a fresh one to start.


        Starting and stopping the Igate daemon
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        The daemon may be started and stopped at any time with the
        commands "START IGATE" and "STOP IGATE".  If the daemon is
        already running, attempting to restart it will simply produce
        an error message, as will trying to stop it if already
        stopped.

        The IGATE.CFG file is re-read each time the daemon is started,
        so the configuration can be changed without stopping XRouter,
        by editing the file (using Notepad or the PZTDOS line editor),
        then re-starting the daemon.  Editing can take place while
        the daemon is running.

        The daemon may be started automatically when XRouter boots, by
        including IGATE=1 in the "global" section of XROUTER.CFG.

SEE ALSO
        APRS(9)        -- Automatic Packet Reporting System.
        DIGIFLAG(1)    -- Display / Set digipeat options.
        EDIT(3)        -- PZTDOS Line Editor.
        IGATE.CFG(8)   -- IGATE Configuration File.
        START(1)       -- Start Daemon Processes.
        STOP(1)        -- List / Stop Daemon Processes.
        TCP(1)         -- TCP status / configuration commands.
        XROUTER.CFG(8) -- Main Configuration File.

IGATE(9)                  END OF DOCUMENT
