IGATE.CFG(8)            XROUTER REFERENCE MANUAL            17/10/2023

NAME
        IGATE.CFG -- IGATE Configuration File.

DESCRIPTION
        IGATE.CFG is the configuration file for the APRS IGATE daemon,
        therefore you do not need it if you are not using IGATE.  It
        is a plain text file read each time the daemon is started. 

FORMAT
        IGATE.CFG is a plain text file.  Each configuration keyword
        is specified on a separate line. Blank lines, or lines
        beginning with ';' or '#' are ignored. The maximum line
        length is 80 characters.

        Within each directive, fields must be separated by one or
        more spaces or tabs. The fields are as follows:

        The following keywords are accepted:

           IFILTER  <from> <to> <text>  Internet->Packet filter rules 
           LOG      <0-255>             Activity logging level
           MAXTRIES <n>                 Max. server connect attempts.
           PAUSE    <seconds>           Interval between retries.
           PFILTER  <from> <to> <text>  Packet->Internet filter rules
           SERVER   <ipaddr:port>       Internet server to use
           SKIP     <seconds>           Blacklist time after failure
           WAIT     <seconds>           Time to wait for connection

      These are fully documented in the section relating to IGATE.

EXAMPLE
      Abbreviated example file:

      ; APRS IGATE Configuration file for XRPi
      ;
      ; You can list as many servers as you like.
      ; They are tried in rotation.
      SERVER 213.180.75.122:2023
      ;
      ; Wait up to 60 secs for connection before trying next server
      WAIT 60
      ;
      ; Wait 60 secs between successive attempts to same server
      PAUSE 60
      ;
      ; Max connect attempts before blacklisting the server
      MAXTRIES 10
      ;
      ; If blacklisted, don't try the server for 1 hour
      SKIP 3600
      ;
      ; IFILTER controls gating from internet to packet:
      ;
      ; IFILTER       From    To      Text
      ; -------------------------------------
        IFILTER       G#*     *       *
      ;
      ; PFILTER statements control gating from packet to internet:
      ;
      ; PFILTER       From    To      Text
      ; ------------------------------------
        PFILTER       G*      AP*     *
        PFILTER       MB7*    AP*     *
      ;
      ; Radius of Interest
      ;
      RADIUS 150
      ;
      ; Activity logging
      ;
      LOG     255


FILES
        If required, IGATE.CFG should be located in the same
        directory as the XRouter executable.

SEE ALSO
        IGATE(9)  -- APRS Internet Gateway.

IGATE.CFG(8)                END OF DOCUMENT
