INFO(1)                 XROUTER REFERENCE MANUAL              7/6/2023

COMMAND
        INFO -- Display information

SYNOPSIS
        I[nfo] [nodecall | nodealias | topic]
        I[nfo] PAGE
        I[nfo] MORE

AVAILABILITY
        The command is available to all users.

DESCRIPTION
        The INFO command displays information about the node, and
        other topics chosen by the sysop. It can also be used to
        display information from other nodes.

OPTIONS
        If no arguments are given, the text specified by INFOMSG in
        XROUTER.CFG is sent to the user.

        If [topic] is specified, the contents of the appropriate .INF 
        file, if it exists, are sent to the user instead.

        If [topic] is "*", all the available info topics are listed.

        "I[nfo] PAGE" displays a built-in page giving pertinent
        infomation about the system, such as its location, software,
        languages, services etc.

        "INFO MORE" displays a built-in page showing technical
        settings which may be of use when trying to diagnose network
        problems. 

        If the argument is a nodecall or alias, and that node is an
        XRouter, and it is in the nodes table, XRouter will obtain
        information from the INFO service (NetRomX service 1) on that
        node. The information is returned in a form which is readable
        by both humans and machines. i.e. of the "<keyword>: <value>"
        form, with each piece of information on a separate line.
        Every keyword is unique.

EXAMPLES
        I FOURPAK   - Displays contents of INFO/FOURPAK.INF file.
        I KIDDER    - Displays info from the KIDDER node.

LIMITATIONS
        Topic file names INFO.INF and MORE.INF are reserved. If you
        create those files, they will not be displayed.

        Info <node> only works with XRouters at present.

FILES
        The sysop may create INFO topics as required, and there is no 
        need to restart XRouter in order to activate them.

        Each topic should be created as a plain text file with the 
        .INF extension and should be placed in the INFO subdirectory 
        located immediately under the router's working directory.

        Files without the .INF extension will not be listed or 
        accessible.

SEE ALSO
        HELP(1)         -- User help command.
        INFO(9)         -- Info system.
        INFO-SVC(9)     -- NetRomX Information Service
        MAN(1)          -- XRouter sysop manual.
        XROUTER.CFG(8)  -- Main configuration file.

INFO(1)                           END OF DOCUMENT
