INP3(9)                 XROUTER REFERENCE MANUAL            17/10/2023

NAME
        INP3 -- Inter-Node Protocol 3.

DESCRIPTION
        INP3 is version 3 of the so-called "Internode Protocol". This
        is a protocol for exchanging time-based routing information
        between neighbour nodes.  Despite the misleading name, it is
        not concerned with general inter-node traffic, only the
        routing information.

        INP3 is analogous to NetRom nodes broadcasts, except that the
        information is "unicast" to each neighbour via the normal
        AX25L2 inter-node links, instead of being broadcast via UI
        frames.

        NetRom nodes broadcasts and INP3 can happily co-exist on the
        same network, as they are are concerned with different
        metrics.  NetRom broadcasts propogate route QUALITY, whilst
        INP3 unicasts propogate TRIP TIME.  These are two completely
        different metrics, and there is NO valid way to convert one to
        the other, especially quality to time, since route quality is
        such a nebulous and subjective quantity.

        However, there is one caveat: Some types of node software,
        including Linux and (X)net (no relation to XRouter!) convert
        time to quality and vice versa.  This causes distorted routing
        when qualities are converted to bogus trip times.  Assigning
        slightly lower route qualities to these neighbours helps to
        prevent traffic being diverted through them. 

        The protocol is summarised below:


        Information Exchange 
        ~~~~~~~~~~~~~~~~~~~~

        All INP3 routing information traffic between two neighbour
        nodes is carried alongside regular inter-node traffic, by
        AX25L2 numbered information frames with PID 0xCF (NetRom).


        Link Quality Estimation
        ~~~~~~~~~~~~~~~~~~~~~~~

        The "quality" of an inter-node link is determined by its mean
        one-way frame transport time, usually measured by the exchange
        of L3RTT frames.  This value is called the Smoothed Neighbour
        Transport Time (SNTT).


        Trip Time
        ~~~~~~~~~

        This is the all-important metric.  For a given target node, it
        is simply the sum of all the intermediate nodes' SNTTs.  It is
        measured in 10ms units, with a maximum (horizon) value of
        60000, i.e. 600 seconds.  A trip time of 60000 is used to mark
        a route as unusable.

        The sysop may set a local limit which is less than 60000 using
        MAXTT.  Routes which exceed the local limit are propogated
        with the horizon value.

        In this context "route" means a path through the network,
        involving one or more intermediate nodes.  The optimum route
        to a target node is generally considered to be the one with
        the lowest trip time.


        Hop Count
        ~~~~~~~~~

        Each inter-node link is counted as one HOP.  This is a second
        metric which is propogated alongside trip time.  Routes with
        lower hop counts are preferred.  A hop count of 30 is
        considered to be the horizon, and marks the route as unusable.

        The sysop may set a local limit which is less than 30 using
        MAXHOPS.  Routes which exceed the local limit are propogated
        with the horizon value.


        Propogation of Routing Information
        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        A route via a neighbour is valid as long as it is regularly
        updated in unicasts from that neighbor, with a trip time less
        than the horizon.  If the route is not regularly updated, or
        the trip time reaches the horizon, that route is marked as
        unusable.  If the link with the neighbour is broken, all
        routes via that neighbour are marked as unusable. 

        Routes with trip time below the horizon are called positive
        information and represent available nodes.  Positive
        information is not time critical and, like NetRom nodes
        broadcasts, is sent at scheduled intervals only.

        Any update of positive information with a slower target time
        (or route loss) is called negative information.  This is
        always propogated immediately.

        Information about nodes which are routed via a neighbour is
        never returned to that neighbour.  Instead it is returned with
        horizon values.  This is called "poisoned reverse". 


        Packet Structure
        ~~~~~~~~~~~~~~~~

        Routing information is exchanged using "Routing Information
        Frames" (RIF), containing one or more Routing Information
        Packet" (RIP).  Each RIP contains information about one node,
        such as callsign,  trip time and hop count, plus optional
        fields such as alias and IP address.

        A RIF starts with a single identification byte of 0xFF. This
        value is guaranteed not to appear in normal L3 frame headers
        as the first byte.  The end of the RIF is marked by a zero
        byte, 0x00.  The following diagram shows a RIF containing
        one RIP:


        Byt: 1      7          1          2            n        1        
        .------.----------.--------.-------------.-----------.------.
        | 0xFF | <axcall> | <hops> | <trip time> | <options> | 0x00 |
        '------'----------'--------'-------------'-----------'------'
                <------ Routing Information Packet --------->
         <-------------- Routing Information Frame ---------------->

        <axcall>      Callsign in AX25 format
        <hops>        No. of hops to target (1-30)
        <trip time>   Trip time to target in 10ms units (1-60000)
        <options>     Variable length options field as below:


        Bytes:      1        1      n = <length>
              .----------.--------.--------------.
              | <length> | <type> |    <data>    |
              '----------'--------'--------------'

              <length>  Length of data field in bytes (0-255)
              <type>    Type of data field (0=alias, 1=IP addr)
              <data>    Data field.

SEE ALSO
        L3RTT(9)   -- Layer 3 Round Trip Time
        MAXHOPS(7) -- Maximum Hop Count.
        MAXTT(7)   -- Maximum Trip Time.
        QUALITY(1) -- NetRom Route Quality.
        ROUTES(1)  -- Add, Drop & List Neighbour Routes.

INP3(9)                     END OF DOCUMENT
