IP-PRIMER(9)            XROUTER REFERENCE MANUAL            17/10/2023

NAME
        IP-PRIMER -- IP Addressing / Routing Primer.

IP ADDRESSES
        All IP addresses consist of a 32 bit binary number, which
        is composed of four 8-bit binary numbers.  For clarity they
        are usually expressed as four decimal numbers separated by
        dots, the so called "dotted quad" form, for example
        44.131.91.2.

        Each of the numbers which make up the quad can range from
        0 to 255, i.e. 256 numbers in total.  The numbers 0, 128
        and 255 are usually reserved for special purposes.

        The most significant (leftmost) number identifies the
        "network" within the whole Internet.  44 was originally
        allocated to Amateur Packet Radio, or "ampr.org". However,
        the upper quarter of this range has now been sold off, so
        44 is no longer exclusively amprnet.

        Within the so-called "amprnet", the second number from the
        left usually identifies the country, although in the USA it
        generally identifies a state. In some parts of the world it
        identifies a group of countries. In our example 131 is the
        code for the whole UK. Numbers 192 and above no longer
        belong to amprnet.

        The third number from the left identifies the "region"
        within the country or state, and in our example region 91
        is North Worcestershire.

        The rightmost number identifies up to 256 separate users
        within the region.  The addresses within a region are
        sometimes allocated on a first come first served" basis,
        or sometimes in groups to allow further subdivision of a
        region.

IP ROUTING
        Unlike NetRom routing, IP routing is often explicitly defined
        by the sysop, although just like NetRom it can be automated
        using RIP (Routing Information Protocol). The IP equivalent
        of a NetRom "nodes table" is the "IP routes table". This can
        be initialised using entries in IPROUTE.SYS.

        The basic idea is that, for any destination IP address,
        XRouter must send the IP packet (usually called a
        "datagram") either directly to the destination (if it's on
        the LAN or within radio range), or to a "gateway" which
        knows how to reach the destination.  In the most extreme
        case, you can simply send all non-local IP traffic to a
        gateway, who will handle it for you.

        Since there are billions of IP addresses, it would be
        impractical to define a route for every possible
        destination. This is where the hierarchical structure
        of IP addresses come to your aid.

        If you are in the USA, you don't need to know explicitly
        how to route to everyone in the UK. All you need to know
        is how to route to the UK, then the routers within the UK
        will do the work for you. If you don't know a route to
        the UK, simply route the traffic to a gateway who does.
        There is always someone willing to act a a gateway on your
        behalf.

        Routing decisions are made using a special combination of
        IP addresses and "bits", for example 44.0.0.0/8. This tells
        XRouter to compare the destination IP address of datagrams
        with the leftmost 8 bits of 44.0.0.0, ignoring the
        rightmost 24 bits. This will match any address beginning
        with 44, i.e. the whole of amprnet (as was). Since the
        rightmost 24 bits are ignored, 44.131.91.2/8 would have
        *exactly* the same effect.

        The higher the number of bits, the more precise the match,
        for example 44.131.0.0/16 would "catch" all datagrams
        addressed to the UK, 44.131.91.0/24 would catch all
        datagrams addressed to North Worcestershire, UK, and
        44.131.91.2/32 would match only one destination, namely
        44.131.91.2.  The "/32" is always the default if the
        number of bits is not specified.

        Having "caught" a destination, the remainder of a routing
        entry tells XRouter which gateway (if any) to send it to,
        which port to send it on, and what mode to use.

        IP routing is usually specified in IPROUTE.SYS using
        commands like this:

        IP ROUTE ADD <host>[/len] <gateway> <port> [mode [metric]]

        Example: IP ROUTE ADD 44.131.93.0/24  44.131.93.240  5  d

        This would route all region 93 traffic (44.131.93.0 -
        44.131.93.255) to the gateway 44.131.93.240 on port 5
        using datagram mode.

ROUTING MODES
        The routing [mode] indicates how the traffic is to to be
        handled, and is specified using a single letter as
        follows:
        
            d = Datagram (direct)
            e = Encap (ip-over-ip protocol 4)
            i = IPIP  (ip-over-ip protocol 94)
            n = Netrom (ip-over-netrom)
            r = Reject
            s = Silent discard
            u = IPUDP  (ip-over-UDP) 
            v = Virtual circuit (ip-over-ax25)
            k = Kernel

        "Datagram" is the usual mode, and is the default if "mode"
                   is omitted. It transmits datagrams "raw" inside
                   SLIP, PPP, Ethernet or AX25 UI frames, according
                   to the protocol used on the the destination port. 
                   There is no error correction at the link layer,
                   so datagram mode should only be used on wire
                   links, or RF links with low loss rates. 

        "Virtual Circuit" mode gives better performance on less
                          than perfect RF links. It transports the
                          IP datagrams inside AX25 <I> frames,
                          detecting and correcting errors at the
                          link layer.

        "Netrom" mode is less efficient, but can "tunnel" datagrams
                 across non-ip sections of the network by wrapping
                 them in Netrom layer 3 frames.

        "Encap" mode is used for IP/IP encapsulation, i.e. sending
                44-net datagrams across the Internet by "wrapping"
                them in datagrams with public Internet addresses.
                This uses IP protocol number 4. Unfortunately, in
                some cases Windows blocks this protocol (see below). 

        "IPIP" is the original IP-within-IP encapsulation mode,
               using IP protocol number 94, and has the advantage
               that it is not blocked by Windows.

        "IPUDP" mode is similar to Encap and IPIP, except that the
                datagrams are first wrapped in UDP before being
                transported in IP.  The advantage is that UDP is
                usually able to pass through routers which don't
                support IPIP or IPEncap, and can be selectively
                routed to different machines according to the UDP
                service port numbers.

        "Reject" entries are used to reject traffic destined for
                 systems which don't exist, or are which not
                 reachable via any port.  If simply routed on the
                 default port, such datagrams would waste resources
                 and would probably end up looping back to us.
                 Datagrams matching a "reject" entry are rejected
                 by returning an ICMP "destination unreachable"
                 report to the sender.  The "gateway" ip address
                  should be 0.0.0.0 and the port number is ignored.

        "Silent Discard" entries are similar to "Reject", except
                         that they simply dump the unwanted
                         datagrams without sending an ICMP error
                         report.  This saves bandwidth when the
                         problem is persistent, and is more
                         suitable than "Reject" for suppressing
                         malicious network probes.
 
        "Kernel" mode is a dummy mode. It tells XRouter to use the
                  host operating system's TCP/IP services to handle
                  this traffic. It is intended only as a last resort,
                  e.g. when operating without the EXTERNAL intarface.
                  The host O/S allows XRouter to originate and
                  terminate TCP, UDP, IPIP, ICMP and AXIP, but not to
                  *route* those protocols.  Therefore, using a mode
                  "k" entry you may Telnet and Ping from XRouter, but
                  you are not allowed to route 3rd party traffic, e.g.
                  from RF to Internet.


ENCAP BLOCKING
        Starting with Windows XP Service Pack 2, the IPEncap (encap)
        protocol 4 was blocked by Windows for so-called "security
        reasons".

        Therefore if you are using WinXPSP2 or a later O/S, encap
        mode can only be used via Ethernet if XR32 is able to
        bypass Windows and talk directly to the Ethernet card using
        the NDISXPKT driver. But this driver is currently only
        available for Windows 2000 and XP.

        This means that, until an NDIS driver is written for later
        versions of Windows, you are not able to use encap mode on
        those platforms.

        However this only applies to Ethernet. If you have a SLIP
        or PPP (i.e. serial cable) link with another system, you
        may use encap mode whatever operating system is in use.

        Linux does not block IPEncap, but you may need to give
        XRouter the required privileges to use it.

ADDRESS RESOLUTION PROTOCOL (ARP)
        ARP is responsible for mapping gateway IP addresses to
        "hardware" (i.e. AX25 or Ethernet) addresses.

        In order to send an IP datagram over an AX25 or Ethernet
        network, it must be "wrapped" in an AX25, Ethernet, or
        Netrom packet, and that packet will need a destination
        address appropriate to that network. For example, to route
        a datagram to 44.131.91.2 it must be wrapped in an AX25
        packet addressed to GB7PZT-5.

        The system *will* sometimes work without any ARP entries,
        due to the process of "ARP resolution", whereby a router
        can make a broadcast asking adjacent systems if they know
        the hardware address for a given IP address, but this
        process takes time and the adjacent routers may not know
        the answer.  Thus, for RF links at least, it is advisable
        to put ARP entries for each of your direct RF neighbours
        int IPROUTE.SYS. The general form of an ARP entry is:

            ARP <ADD | PUBLISH> <host> <hwtype> <hwaddr>

        <host>   is the neighbour's IP address in dotted quad form.

        <hwtype> is the hardware address type, i.e. "ax25"
                 "netrom" or "ether".

        <hwaddr> is the hardware address, i.e. AX25 callsign or
                 Ethernet address.

        Example ARP entries:

        This one causes datagrams bound for 44.131.90.6 to be
        wrapped in AX25 packets addressed to GB7IPT-9:

             arp add 44.131.90.6  ax25  GB7IPT-9

        Whereas the following will send datagrams bound for
        44.131.95.7 to the G7GHP-5 system via the GB7DIG digipeater.
        Up to 8 digipeaters may be used in a single comma-delimited
        string:

             arp add 44.131.95.7  ax25  G7GHP-5,GB7DIG

        This one will wrap datagrams destined for 44.131.24.1 in
        Netrom packets addressed to node GB7CX:

             arp add 44.131.24.1  netrom  GB7CX

        The following will wrap the datagrams in ethernet packets.

             arp add 44.131.91.9  ether  00:00:1B:2C:04:81

        ARP PUBLISH is used in cases where one system is "hidden"
        behind another, and allows other systems to discover the
        correct hardware address to use.

        For example, say 44.131.91.127 is only reachable via
        44.131.91.245.  Unless all the local systems were
        specifically configured to route to 91.127 via 91.245,
        they wouldn't know how to do it. Including the entry:
        "arp publish 44.131.91.127 ax25 g8pzt" on the 91.245
        (g8pzt) router causes it to respond to anyone who asks
        for the hardware address for 91.127, giving its own ax25
        address.

SEE ALSO
        ARP(1)         -- Address Resolution Protocol Commands.
        IP(1)          -- IP Routing / Configuration Commands
        IPROUTE.SYS(8) -- IP Router Control File.

IP-PRIMER(9)                END OF DOCUMENT
