;*************************** Max Width *******************************
IP-STACKS(6)          XROUTER REFERENCE MANUAL               22/9/2023

NAME
        IP-STACKS -- TCP/IP Stacks in XRouter.

DESCRIPTION
        A TCP/IP "stack" is a set of protocols layered on top of
        each other in such a way that each layer only talks to the
        layer immediately above or below it. There is no lateral
        communication within layers.

        At the top of the stack is the "Application Layer", which is
        basically where humans and processes interact with the stack,
        and at the bottom is the "Physical Layer", which is where the
        PC interfaces to the outside world, via Network Interface
        Cards (NIC's), sound cards, COM ports etc.

        The following diagram is a greatly simplified version of
        XRouter's TCP/IP stack. Some components have been omitted for
        clarity, and to save space. 

          .----------------------------------------------------.
          |                 (Application Layer)                |        
          | TELNET | FTP | HTTP | etc.. | DNS | RIP | PING etc.|
          |--------'-----'------'-------'-----------'----------|
          |             TCP             |    UDP    |   ICMP   |
          |-----------------------------'-----------'----------|
          |                      IP                            |
          |--------------------------------------.------.------|
          |               ARP                    |      |      |
          |------------.-------------------------|      |      |
          |  Ethernet  |       Ax25              | SLIP | PPP  |
          |------------|------------------.------|      |      |
          |  NDISXPKT  |      AGWPE       | KISS |      |      |
          |------------|-----------.------'------'------'------'
          |     NIC    | SOUNDCARD |        COM PORTS          |
          |                  (Physical Layer)                  |
          '----------------------------------------------------'

                    Fig.1 - XRouter's TCP/IP Stack

        To illustrate the workings of a TCP/IP stack, imagine that the
        application initiates a TELNET connection. It can be seen from
        Fig.1 that in order to reach the outside world, TELNET uses
        TCP, which in turn uses IP. From that point downwards there
        are several choices, depending on the destination address, the
        IP routing tables, and the hardware interfaces that have been
        defined in XROUTER.CFG.

        If the destination is an Internet site, the data may pass down
        through ARP, Ethernet and NDIS, to emerge from the NIC onto
        the LAN, thence to the Internet router and the Internet.

        If however the destination was a local Ham Radio TCP/IP hub,
        the data might pass from IP down through ARP and AX25, then it
        would either go via KISS and a COM port to a TNC, or via AGW
        Packet Engine and a sound card, thence to the radio.

        Alternatively the destination may be another PC, linked via
        COM ports. In this case, the data would pass from IP down
        through SLIP or PPP to the COM port.

        Two Stacks
        ==========
     
        Although XRouter has its own TCP/IP stack, Linux has a much
        larger and more comprehensive stack of its own. The two are
        independent of each other, and different to each other...

        History Digression:
        ~~~~~~~~~~~~~~~~~~~
        
        XRouter's stack originated in the 1990's, when XRouter ran on
        DOS. There was no TCP/IP stack in DOS, so XRouter evolved as a
        way to provide one, both for Internet and for TCP/IP over RF.

        Because of this, XRouter's stack was multi-homed. i.e. it
        could exist on several networks at the same time, with
        different IP addresses on each network. For example it may be
        simultaneously using the IP address 44.131.91.2 for radio
        links, 192.168.0.23 for Ethernet, and 10.0.0.2 on a SLIP link.

        Many years later, when XRouter was ported to Windows and
        became "XR32", Windows by now had a comprehensive TCP/IP stack
        of its own. Consequently, some of the functionality provided
        by XR32's stack could be provided equally well by the Windows
        stack.

        But not all of it. Windows could not provide any AX25
        services, and it was almost impossible to set up and use
        Windows TCP/IP via packet radio RF links.

        So XR32 was able to make use of Windows' TCP/IP stack for
        Internet operations, whilst using its own stack for TCP/IP
        over radio. Or it could be configured to ignore Windows'
        stack and do everything via its own stack. Or a mixture of
        the two, as specified by the sysop.

        XR32 was later ported to Linux to become XRPi/XRLin. But
        Linux already has a very powerful networking stack which
        includes AX25, so some might question the need for XRouter to
        have a stack, or even to exist at all!

                    ----------------------------

        The point is, XRouter is an experiment in amateur networking.
        New ideas can be quickly tried out without breaking the Linux
        stack, or going through a long-winded process to get the code
        incorporated into the Linux kernal. Ideas that don't succeed
        can easily be discarded, and no kernals are harmed in the
        attempt.

        XRouter can do many things that the Linux stack cannot, all
        in one simple package. The sysop has full control over which
        TCP/IP services use which stack.

        At the application layer, XRouter can use either or both
        TCP/IP stacks, as shown in the simplified diagrams below:


                .-----------------------------------------.
                |         XRouter Application Layer       |
                |-----------------------------------------|
                |  XRouter IP Stack  |  Linux IP stack    |
                |    192.168.0.23    |    192.168.0.1     |
                '-----------------------------------------'

                      Fig.2 - XRouter Using Both Stacks

        Figure 2 shows the application layer sitting astride both
        stacks. For example, the FTP server might be available on
        both kernal and XRouter IP addresses, either with the same or
        different TCP port numbers.

        Or you might wish to restrict the FTP server to the Linux
        stack, firewalled from the outside world, whilst the Telnet
        server sits on the XRouter stack, port-forwarded from the
        outside world. The possibilities are endless, and up to you.


                .--------------------.
                | XRouter Appl Layer |
                |--------------------|--------------------.
                |  XRouter IP Stack  |  Linux IP stack    |
                |    192.168.0.23    |    192.168.0.1     |
                '-----------------------------------------'

                       Fig.3 - XRouter Using Own Stack

        Figure 3 shows XRouter's application layer sitting wholly
        astride its own TCP/IP stack, such that it makes no use of
        the Linux stack at all.


                                     .--------------------.
                                     | XRouter Appl Layer |
                .--------------------|--------------------.
                |  XRouter IP Stack  |  Linux IP stack    |
                |    192.168.0.23    |    192.168.0.1     |
                '-----------------------------------------'

                       Fig.4 - XRouter Using Linux Stack

        Conversely all of XRouter's applications (FTP, HTTP, Telnet
        etc.) could use only the Linux stack, as shown in figure 4.
        In this case it wouldn't even be necessary to give XRouter
        an IP address.

        At the physical layer, XRouter's TCP/IP stack shares the
        Ethernet and WiFi adaptors with Linux, whilst using its own
        IP addresses. This is shown in the simplified diagram below
        (which omits KISS etc. for clarity):


                .-----------------------------------------.
                |  XRouter IP Stack  |  Linux IP stack    |
                |    192.168.0.23    |    192.168.0.1     |
                |-----------------------------------------|
                |          Ethernet / WiFi Adaptors       |
                '-----------------------------------------'

                Fig.5 - IP Stacks Sharing Physical Resources


        To Root or Not to Root?
        ~~~~~~~~~~~~~~~~~~~~~~~

        In order to directly share the physical resources, XRouter
        either needs root privileges, or it needs to be given
        permission to access raw network resources.

        Running as root is more convenient in that it allows XRouter
        to open any TCP or UDP port on the Linux stack, but some may
        consider it to be a security risk.

        For example, in the highly unlikely event that someone breaks
        out of XRouter to a command line, they could have access to
        the whole machine. However, XRouter has been in use for
        several years fully open to the Internet, without incident.

        Running XRouter as a non-root user is safer. Even if a
        miscreant managed to break out to a command shell, he would
        only have access to that user's directory tree.

        The downside of non-root is that Linux would not allow
        XRouter to open TCP/UDP port numbers below 1024 on the Linux
        stack. So for example you could not run FTP servers at port
        21 on both stacks. There would be no restriction on the
        XRouter stack, but the port number on the Linux stack would
        have to be greater than 1023.

        But that is a small price to pay for the added security.

        If you run XRouter as shown in figure 4, it needs no special
        privileges at all. But you will not be able to trace much of
        the TCP/IP traffic, and some facilities will be unavaliable.

        Which Stack to Use?
        ~~~~~~~~~~~~~~~~~~~

        The choice of how your TCP/IP packets are routed, and which
        stack your services appear on, is entirely under your
        control. It could have been automated, but that would have
        deprived you of choice.

        If you haven't defined an Ethernet or Wlan port, and you
        haven't defined any RF, SLIP or PPP routing, TCP/IP traffic
        will use the Linux stack. If you are not running XRouter from
        a root account, and have not set the correct capability flags
        on the program, some services such as PING AXIP, IPIP and
        TELNET won't be available, and your server ports may be
        restricted to service numbers 1024 and above.

        If you have defined an Ethernet or Wlan port, all TCP/IP
        traffic (except to localhost) will try to route via XRouter's
        own stack, and all servers are on that stack unless the
        defaults are overidden.

        The way to force traffic via the Linux stack is to use
        IP ROUTE entries with mode "k" (kernal) instead of "d".
        Anything not caught by a "k" entry will then be routed via
        XRouter's stack. 
	  
SEE ALSO
        IP(1)          -- IP Configuration Commands.
        IPROUTE.SYS(8) -- IP Configuration & Routing File.
        IP-PRIMER(9)   -- IP Primer.

IP-STACKS(6)              END OF DOCUMENT
