IP(1)                 XROUTER REFERENCE MANUAL                8/9/2023

COMMAND
        IP -- Display / Change IP routing parameters.

SYNOPSIS
        IP B[an] A[dd] <ipaddr> [netmask]
        IP B[an] D[rop] <ipaddr>
        IP B[an] L[ist]
        IP B[an] P[ort] A[dd] <TCP|UDP|ALL> <start> [end]
        IP B[an] P[ort] D[rop] <TCP|UDP|ALL> <start> <end>
        IP B[an] P[ort] L[ist]
        IP B[an] P[ort] S[ave]
        IP B[an] S[ave]
        IP C[onfig]
        IP H[eard]
        IP Q[uiet] [level]
        IP ROUTES
        IP R[oute] A[dd] <host>[/len] <gateway> <port>
                         [mode [metric [private]]
        IP R[oute] ADDP[rivate] <host/len> <mode> <gateway>
        IP R[oute] C[md] [0-1]
        IP R[oute] D[rop] <host> <len>
        IP R[oute] DE[fault] <port> [gateway [mode]]
        IP R[oute] L[ist]
        IP R[oute] LO[ad]
        IP R[oute] LOO[kup] <host>
        IP T[tl] [ttl]
        IP U[nban] <ipaddr>

AVAILABILITY
        The IP ROUTES command is available to all, providing it
        hasn't been disabled by sysop. The remaining commands are
        sysop-only.

DESCRIPTION
        The IP commands are used to display and alter some of the IP
        parameters, the contents of the table responsible for
        routing of IP datagrams, and the ban lists.

        The arguments are as follows:

        <host>      Target hostname or IP address. IP address is
                    preferred, as it is more efficient. Route default
                    must always be an IP address.

        <len>       No. of bits to be matched (from left) 0-32

        <gateway>   Destination gateway IP address in dotted quad.
 
        <port>      Port number on which to route the datagram.
                    For encapsulated modes (e,i,u), Netrom and reject
                    modes (r and s) this is ignored and should be 0.
                    For IPUDP, this can optionally specify the UDP
                    service number to use (default=94).

        <mode>      How the datagram is routed, as follows..

                      d = Datagram (direct)
                      e = Encap (ip-over-ip protocol 4)
                      i = IPIP  (ip-over-ip protocol 94)
                      k = kernel (via Linux/Windows)
                      n = Netrom (ip-over-netrom)
                      r = Reject
                      s = Silent discard
                      u = IPUDP  (ip-over-UDP) 
                      v = Virtual circuit (ip-over-ax25)

                    The usual mode is "datagram". However, on less
                    than perfect RF links, better performance can be
                    obtained by using Virtual Circuit mode.  Netrom
                    mode is inefficient, but can "tunnel" datagrams
                    across non-ip parts of the network.
                    Encap, IPIP and IPUDP are used for tunneling
                    amateur IP across the public internet.
                    Reject and Silent discard are used to suppress
                    bouncing and looping.
                    Kernel mode is a dummy mode. It tells XRouter to
                    use the Windows / Linux IP stack for anything
                    matching the entry, but see Caveats below.

OPTIONS
        The QUIET subcommand is used to display or set XRouter's
        "stealth" level, i.e. how it responds to ICMP echo requests
        and TCP port probes. If the level is zero, XRouter behaves
        normally. If a non-zero argument is supplied, XRouter becomes
        stealthy. The stealth level is specified by adding the
        following values:

            1   Suppress ICMP echo replies.
            2   Suppress Protocol unreachable
            4   Suppress TCP refusals
            8   Suppress all ICMP errors
        
        ROUTE CMD is used to allow / disallow the IP ROUTES and
        IPR[outes] commands from being used by non-sysops. On amateur
        networks however, it is considered bad practice to hide IP
        routing.

        The ROUTE DEFAULT subcommand sets up a default route which is
        used when no other route is found.  If no gateway is
        specified, the target will be assumed to be a direct
        neighbour.  If not specified, the mode defaults to datagram.

        The ROUTE ADD subcommand adds an entry to the routing table.
        The first argument is the target host IP address, with
        optional mask. e.g. 44.131.90.1/32 means "match all 32 bits",
        whereas 44.131.90.0/24 means "match the most significant 24
        bits", and would route all 256 addresses from 44.131.90.0 to 
        44.131.90.255.
        The second argument is the "gateway" address, i.e. the
        address  of the system which can handle the datagram.
        The third argument is the port to route the datagram on, and 
        the last argument is the mode (see above).
 
        The ROUTE ADDPRIVATE subcommand is the same as ROUTE ADD,
        except that it marks the route "private", hiding it from
        non-sysops. The regular form has the same syntax as ROUTE ADD
        and can accept any mode, whereas the shortened form is
        provided for backward compatibility with "encap.txt", and can
        only accept mode "encap".

        The ROUTE DROP subcommand removes an entry from the table.
        Both the target host and the mask must match.

        The ROUTE LOAD subcommand clears the existing IP parameters
        and tables, and reloads them from IPROUTE.SYS.

        The ROUTE LOOKUP subcommand displays the gateway and port
        which XRouter will use to reach a given destination.

        The CONFIG sub-command displays lots of information about the
        IP configuration of the main stack and the various ports.

        The HEARD subcommand displays the IP addresses from whom
        datagrams have been received, along with the date and time
        when they were last heard, the number of packets and number
        of bytes received.

        The TTL subcommand specifies the default "Time To Live" for
        datagrams originating at this host.

        Sub-commands "IP BAN ADD" and "IP BAN DROP" allow manual
        editing of the "banned IP" list. The short forms of those
        commands, IP BAN and IP UNBAN, still work....

        The sub-command "IP BAN SAVE" saves the list of banned IP
        addresses to the file IPBAN.SYS. The contents of the file
        are reloaded at boot-up. The ban list is always saved at
        closedown, but this command can be used in CRONTAB.SYS to
        additionallly save the ban list from time to time in case of
        power cuts.

        Sub-commands IP BAN PORT ADD, IP BAN PORT DROP, IP BAN PORT
        LIST, and IP BAN PORT SAVE allow management of the "honeypot"
        ports (see below).

EXAMPLES
        IP ROUTE DEFAULT 3 44.131.90.6 v
        IP ROUTE ADD 44.131.95.0/24 44.131.95.240 9 d
        IP ROUTE DROP 44.131.97.1 32
        IP ROUTE LOOKUP bbc.co.uk
        IP BAN PORT ADD tcp 445

FILES
        The IP commands may be used in IPROUTE.SYS and BOOTCMDS.SYS
        but the only ones that have any meaning in those locations
        are IP ROUTE ADD, IP ROUTE DEFAULT, IP TTL and IP QUIET. It
        is usual to define IP routing in IPROUTE.SYS.

        When XRouter boots, it first reads IPROUTE.SYS, then
        ENCAP.TXT, then finally BOOTCMDS.SYS.

CAVEATS
        Mode "k" should be used with caution. It means "Use kernal
        TCP/IP services to reach this destination", and is intended
        only for when the XRouter stack can't be used.

        For "security reasons" Windows does not allow applications
        to route raw IP traffic through its stack. It actively
        blocks IP protocol 4 (IPEncap), and puts severe restrictions
        on TCP and UDP traffic.

        Windows allows XRouter to originate and terminate TCP, UDP,
        IPIP, ICMP and AXIP, but not to *route* those protocols.
        Therefore you may Telnet and Ping from XRouter, but you are not
        allowed to route 3rd party traffic, e.g. from RF to Internet.

NOTES
        The IP routing table is necessary only for IP, and does not 
        take any part in normal ax25 and Netrom activities.  See the 
        full manual for details on how to set up the IP system.

        Please do not over-use ADDPRIVATE, as it hinders the
        diagnosis of networking problems, and many consider it to
        be contrary to the spirit of Ham Radio.

        Honeypots
        ~~~~~~~~~
        In this context, a honeypot a sticky trap, set up on popular
        TCP or UDP ports, for catching internet low-life.

        Hackbots generally start their attacks by probing for open
        TCP ports, and to save time they often start with the most
        popular ones - telnet, SSH, HTTP, VNC and so on. If they find
        an open port, they tend to inform each other, then they all
        concentrate their attacks on that port.

        Unless you have a particular service port open, the chances
        are that anyone who tries to connect to it is up to no good.
        So the honeypot is a mitigation measure. It LOOKS like an
        attractive open port, but it's not! Anyone who connects to it
        gets their IP address logged and banned. After that they
        can't do any more attacking unless they change their IP
        address.

        It's not foolproof. Nation states and sophisticated hackers
        have access to virtually unlimited IP addresses. But it slows
        them down, and the IDS alerts you that there is a problem.

SEE ALSO
        IP-PRIMER(9) -- IP Addressing / Routing Primer.
        IPROUTE(1)   -- Display IP Routes
        IDS(9)       -- Intrusion Detection System
        IPBAN.SYS(8) -- Banned IP addresses File.

IP(1)                        END OF DOCUMENT
