;*************************** Max Width *******************************
IPADDRESS(7)          XROUTER REFERENCE MANUAL               25/9/2023

NAME
        IPADDRESS -- Main or Port IP Address.

SYNOPSIS
        IPADDRESS=<ip_address>

DESCRIPTION
        IPADDRESS is a directive used in XROUTER.CFG. It can be used
        both "globally" and within a PORT configuration block.

        If used in the "global" section, it specifies the "core" IP
        address, inherited by all ports. If used within a PORT
        definition block, it specifies an additional IP address that
        is used instead of the global IP address for all TCP/IP
        operations on that port.

        The "core" IP address is used as the "inner" address for
        tunneled IP, e.g. for IPIP, IPENCAP, IPUDP etc. If you have
        an AMPRNET address, it is therefore important that you use
        that as the CORE address, and use your private LAN address
        in the approriate PORT block. It doesn't have to be amprnet
        of course - you may wish to establish a private network on
        another address range. 

EXAMPLE
        IPADDRESS=44.131.91.5 

CAVEATS
        If you set the global IPADDRESS to 0.0.0.0 or leave it
        undefined, *all* IP activity is disabled, including AXUDP,
        AXTCP, AXIP, HTTP, FTP etc on BOTH stacks! This is a
        deliberate security feature (it may be changed in future).

        Therefore at present, if you don't have an amprnet address,
        and you want to use any IP services, it is suggested that you
        set a non-zero dummy IP address such as 10.1.1.1 for the core.

        A common mistake is to use a LAN address for the core IP, and
        amprnet addresses for AXUDP operations. This is very bad
        practice, because it forces the packets to traverse the IP
        stack several times, which is not only ineffficient, but can
        lead to death-loops.

SEE ALSO
        IP-STACKS(6)   -- IP Stacks in XRouter.
        IP-PRIMER(9)   -- IP Primer.
        NETMASK(7)     -- Port Subnet Mask.
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

IPADDRESS(7)                  END OF DOCUMENT
