IPBAN.SYS(8)           XROUTER REFERENCE MANUAL              13/6/2019

NAME
        IPBAN.SYS -- Banned IP addresses file.

DESCRIPTION
        This optional file is read at bootup. It stores the list of
        "banned" IP addresses, plus "honeypot" ports.

        If the file doesn't exist, it is created at closedown or by
        the "IP BAN SAVE" command, if there are any entries to save.
        That comand may also be used in CRONTAB.SYS to save the list
        ar regular intervals.

        The ban and honeypot lists can be viewed and edited during
        run-time using the "IP BAN" command and its sub-commands.

        IP Banning
        ~~~~~~~~~~
        If XRouter's IDS (Intrusion Detection System) detects
        malicious activity on its own TCP/IP stack, it will "ban" the
        originator's IP address. Any further packets from that IP
        address are be ignored, as long as the ban lasts.

        If malicious activity is detected on any Linux TCP or UDP
        port that is currently "owned" by XRouter, that also causes
        a ban. In this case, TCP connections are terminated, and any
        further connections of UDP frames are ignored.

        There is no time limit on IP bans. Up to 200 IP addresses can
        be banned at once. A larger table would become unwieldy. When
        a new address is added, the oldest one is dropped. In
        practice this isn't usually a problem because the oldest
        aggressor has usually given up long ago, and is unlikely to
        come back.

        Honeypots
        ~~~~~~~~~
        In this context, a honeypot a sticky trap, set up on popular
        TCP or UDP ports, for catching internet low-life.

        Hackbots generally start their attacks by probing for open
        TCP ports, and to save time they often start with the most
        popular ones - telnet, SSH, HTTP, VNC and so on. If they find
        an open port, they tend to inform each other, then they all
        concentrate their attacks on that port.

        Unless you have a particular service port open, the chances
        are that anyone who tries to connect to it is up to no good.
        So the honeypot is a mitigation measure. It LOOKS like an
        attractive open port, but it's not! Anyone who connects to it
        gets their IP address logged and banned. After that they
        can't do any more attacking unless they change their IP
        address.

        It's not foolproof. Nation states and sophisticated hackers
        have access to virtually unlimited IP addresses. But it slows
        them down, and the IDS alerts you that there is a problem.

FORMAT
        IPBAN.SYS is a text file, so it can be viewed and edited with
        any text editor, although there should be no need to do so.

        Each "entry" in the file is on a separate line.

        There are TWO types of entry in IPBAN.SYS, one for banned IP
        addresses, and the other for honeypot definitions. The
        banned IP entries are of the form:

            <ipaddr> <netmask> <type> <hits> <last-hit>

        Where:

            <ipaddr>   is the IP address being banned.
            <netmask>  specifies how much of the IP address to match
            <type>     is the type of ban: A=automatic, M=manual
            <hits>     is the number of times the IP has been seen
            <last-hit> is the date/time of the last "hit".

        "Automatic" bans are the ones added automatically by XRouter
        when it detects malicious activity. "Manual" bans are those
        added by the sysop using the "IP BAN" command.

        Honeypot entries have the form:

            <start> <end> <protocols> <hits> <last-hit>

        Where:

            <start>     is the first TCP/UDP port in the trap range
            <end>       is the last TCP/UDP port in the trap range
            <protocols> are the protocols to trap:
                        (1=TCP, 2=UDP, 3=both)
            <hits>      is the number of times the trap was sprung
            <last-hit>  is the date/time iof the last activation

        Date/time is a decimal number representing the number of
        seconds since 1/1/1970.

EXAMPLES
        ; Manual ban for 22.33.44.55 with 123 hits
        22.33.44.55  255.255.255.255  M  123  456789012

        ; Manual ban for 33.22.0.0/16 with no hits yet
        33.22.33.11  255.255.0.0      M  0    0

        ; Automatic ban for 80.193.161.2, seen 789 times
        80.193.161.2 255.255.255.255  A  789  324565789

        ; Honeypot on UDP port 211, no hits yet
        211  211   2  0  0

        ; Honeypot on VNC ports 5900-5999, both TCP and UDP
        5900 5999  3  0  0

SEE ALSO
        IP(1)          -- IP related commands
        CRONTAB.SYS(8) -- Time dependent comands

IPBAN.SYS(8)                END OF DOCUMENT
