IPENCAP(9)              XROUTER REFERENCE MANUAL            17/10/2023

NAME
        IPENCAP -- IP-in-IP Encapsulation.

DESCRIPTION
        The orginal form of IP-within-IP encapsulation, used by
        KA9Q NOS to tunnel amateur IP (amprnet or 44-net) datagrams
        via the public Internet, was IPIP, which used protocol number
        94.  Somewhere in the mists of time, the protocol number was
        changed to 4 and the protocol was renamed IPENCAP (usally
        referred to as ENCAP, but sometimes still called IPIP).

        The structure of both types is the same, and is shown below.
        Only the IP "protocol" number is different.  It can be seen
        that the amprnet (inner) datagram is carried within the
        "payload" section of a public (outer) IP datagram:

                .------------------.--------------------------.
                | Public IP header |    Amprnet IP datagram   |
                '------------------'--------------------------'
                <-------------- Public IP datagram ----------->


        Unfortunately IPENCAP is deliberately blocked by Windows,
        starting with XP Service Pack 2, as a "security measure".
        Therefore, **unless you use the NdisXpkt driver**, it is not
        possible to use IPENCAP via an **Ethernet adaptor** with XR32.
        This is a Windows problem, not an XR32 problem!!  However, it
        is still possible to use IPEncap via SLIP and PPP links.

        (Note that the older form of the protocol, IPIP (protocol 94)
        *isn't* blocked by Windows, and may be therefore be used
        without NdisXpkt.)

        There are no sush restrictions on the DOS and Linux versions
        of XRouter.

        IPENCAP can be used to route amprnet datagrams across *any*
        TCP/IP network, not just the Internet.  For example it can be
        used to tunnel datagrams between nodes on a LAN.  In this case
        the "outer" IP header would contain LAN IP addresses, and the
        "inner" header might contain amprnet IP addresses.

        The IPENCAP protocol is used extensively between amprnet
        gateways.  The routing entries to achieve this are found in
        file ENCAP.TXT (usually only available by secure FTP). See
        the MAN page for ENCAP.TXT for more info.


        Configuring IPENCAP
        ~~~~~~~~~~~~~~~~~~~

        Note: For the purposes of this guide it is assumed that your
        connection to the Internet is via a domestic NAT/PAT router
        with firewall. 

        This may sound obvious, but in order to create any form of
        tunnel between amprnet hosts, each host needs both an amprnet
        (44.x.x.x.) and a public (e.g. 62.x.x.x) address. You MUST
        ensure that your amprnet IP address is specified as XRouter's
        "main" address, by including the line IPADDRESS=44.x.x.x near
        the top of the XROUTER.CFG file (replacing x.x.x with your IP
        address). 

        If you are using the EXTERNAL interface (which allows XRouter
        to use its own IP stack), you then "override" the main address
        on the port which connects to the LAN or Internet, by
        including a different IPADDRESS= statement in the PORT block.

        If you are not using the EXTERNAL interface, Windows or Linux
        provides the LAN/Internet IP address for you. 

        Secondly, you and your link partner(s) must set up and test
        IP routing between your public (i.e. non-44.x.x.x) IP
        addresses.  You cannot proceed until this step is complete! 

        IPENCAP encapsulation is specified by IP ROUTE entries with
        mode "e" (encap).  For example, the format to use in
        IPROUTE.SYS is as follows:

             IP ROUTE ADD  44.131.91.0/24  66.23.18.2  0  encap

        The first IP address is the amateur IP address, or range
        thereof, to be routed via this IPENCAP tunnel.  If you don't
        fully understand this format, see the MAN page for the IP
        command. 

        The second address is the public IP address or hostname of the
        link partner to whom the first address(es) will be routed.  It
        is more efficient to use an IP address if possible, rather
        than a hostname, but the hostname may be required if the
        partner's public IP address changes frequently. (DO NOT put
        the partner's 44-net address in here!) 

        The last but one field (which is normally an XRouter PORT
        number in normal route entries) is ignored and you set it to
        zero.

        Mode "encap" signifies IPENCAP encapsulation. 

        In ENCAP.TXT and XENCAP.TXT the format is as follows:

             route addprivate 44.0.0.0/8 encap 66.23.18.2

        In either case the mode "encap" can be abbreviated to "e"
        alone.

        Be aware that IPENCAP is subject to your access control rules,
        and depending on your existing rules you may need to add the
        following line to your rules in IPROUTE.SYS...

            ACL PERMIT  0.0.0.0/32  0.0.0.0/0


        Internet Routers
        ~~~~~~~~~~~~~~~~

        If you wish to route IPENCAP across the Internet, don't forget
        to specify a routing for IP *protocol* 4 (note *protocol* not
        TCP/UDP port) in any "front-end" routers:

        If XRouter is indirectly connected to the Internet via an
        intermediate router, that router will probably be using some
        form of NAT (Network Address Translation) to share one
        "public" IP address between several systems on your LAN.  The
        "front end" router will probably route outgoing IPENCAP
        without problem, but it will not know where to send incoming
        IPENCAP unless explicitly configured.

        Configuring such a router for IPENCAP usually involves
        specifying a protocol number (4 for IPENCAP), and the LAN IP
        address of a machine to which it should be routed, i.e.
        XRouter's LAN IP address.

        You are advised that not all domestic routers can be
        configured to route *incoming* IPENCAP as it is not a
        commercially recognised protocol.  Some routers only allow
        TCP and UDP port forwarding, with no provision for any other
        protocol.  If you or your link partner have such a router,
        you may need to consider IPUDP instead.

SEE ALSO
        ENCAP.TXT(8)   -- Amprnet Encapsulated Routing File.
        IP(1)          -- IP Routing / Configuration Commands.
        IPIP(9)        -- IPIP Protocol.
        IPROUTE.SYS(8) -- IP Routing / Configuration File.
        IPUDP(9)       -- IP-within-UDP Encapsulation.
        XROUTER.CFG(8) -- Main Configuration File.

IPENCAP(9)                  END OF DOCUMENT
