IPIP(9)                 XROUTER REFERENCE MANUAL            17/10/2023

NAME
        IPIP -- IPIP Encapsulation.

DESCRIPTION
        IPIP is the "old" form of IP-within-IP encapsulation, used by
        KA9Q NOS to tunnel amateur IP (amprnet or 44-net) datagrams
        via the public Internet.  Somewhere in the mists of time, the
        protocol number was changed to 4 and the protocol was renamed
        IPEncap (usally referred to as ENCAP).

        The structure of both types is the same, and is shown below.
        Only the IP "protocol" number is different.  It can be seen
        that the amprnet (inner) datagram is carried within the
        "payload" section of a public (outer) IP datagram:

                .------------------.--------------------------.
                | Public IP header |    Amprnet IP datagram   |
                '------------------'--------------------------'
                <-------------- Public IP datagram ----------->


        Unfortunately IPEncap is deliberately blocked by Windows,
        starting with XP Service Pack 2, as a "security measure".
        Therefore, **unless you use the NdisXpkt driver**, it is not
        possible to use IPEncap with XR32.  This is a Windows
        problem, not an XR32 problem!! There are no such restrictions
        on the DOS and Linux versions of XRouter.

        IPIP provides an alternative to IPEncap that ISN'T blocked by
        Windows.  If you are using the NDIS driver, IPIP is provided
        automatically.  If you are not using NDIS, you need to put
        IPIP=1 in XROUTER.CFG in order to activate IPIP.

        IPIP can be used to route amprnet datagrams across *any*
        TCP/IP network, not just the Internet.  For example it can be
        used to tunnel datagrams between nodes on a LAN.  In this case
        the "outer" IP header would contain LAN IP addresses, and the
        inner IP header might contain amprnet addresses.


        Configuring IPIP
        ~~~~~~~~~~~~~~~~

        Note: For the purposes of this guide it is assumed that your
        connection to the Internet is via a domestic NAT/PAT router
        with firewall. 

        This may sound obvious, but in order to create any form of
        tunnel between amprnet hosts, each host needs both an amprnet
        (44.x.x.x.) and a public (e.g. 62.x.x.x) address. You MUST
        ensure that your amprnet IP address is specified as XRouter's
        "main" address, by including the line IPADDRESS=44.x.x.x near
        the top of the XROUTER.CFG file (replacing x.x.x with your IP
        address). 

        If you are using the EXTERNAL interface (which allows XRouter
        to use its own IP stack), you then "override" the main IP 
        address on the port which connects to the LAN or Internet, by
        including a different IPADDRESS= statement in the PORT block.

        If you are not using the EXTERNAL interface, Windows or Linux
        provides the LAN/Internet IP address for you. 

        Secondly, you and your link partner(s) must set up and test
        IP routing between your public (i.e. non-44.x.x.x) IP
        addresses.  You cannot proceed until this step is complete! 

        IPIP encapsulation is specified by IP ROUTE entries with mode
        "i". For example, the format to use in IPROUTE.SYS is as
        follows:

             IP ROUTE ADD  44.131.91.0/24  66.23.18.2  0  ipip

        The first IP address is the amateur IP address, or range
        thereof, to be routed via this IPIP tunnel.  If you don't
        fully understand this format, see the MAN page for the IP
        command. 

        The second address is the public IP address or hostname of the
        link partner to whom the first address(es) will be routed.  It
        is more efficient to use an IP address if possible, rather
        than a hostname, but the hostname may be required if the
        partner's public IP address changes frequently. (DO NOT put
        the partner's 44-net address in here!) 

        The last but one field (which is normally an XRouter PORT
        number in normal route entries) is ignored and you set it to
        zero.

        Mode "ipip" signifies IPIP encapsulation. 

        In XENCAP.TXT the format is as follows:

             route addprivate 44.0.0.0/8 ipip 66.23.18.2

        In either case the mode "ipip" can be abbreviated to "i"
        alone.  Mode "ipip" is allowed in XENCAP.TXT but not in
        ENCAP.TXT.

        Be aware that IPIP is subject to your access control rules,
        and depending on your existing rules you may need to add the
        following line to your rules in IPROUTE.SYS...

            ACL PERMIT  0.0.0.0/32  0.0.0.0/0


        Internet Routers
        ~~~~~~~~~~~~~~~~

        If you wish to route IPIP across the Internet, don't forget to
        specify a routing for IP *protocol* 94 (note *protocol* not
        TCP/UDP port) in any "front-end" routers:

        If XRouter is indirectly connected to the Internet via an
        intermediate router, that router will probably be using some
        form of NAT (Network Address Translation) to share one
        "public" IP address between several systems on your LAN.  The
        "front end" router will probably route outgoing IPIP without
        problem, but it will not know where to send incoming IPIP
        unless explicitly configured.

        Configuring such a router for IPIP usually involves specifying
        a protocol number (94 for IPIP), and the LAN IP address of a
        machine to which it should be routed, i.e. XRouter's LAN IP
        address.

        You are advised that not all domestic routers can be
        configured to route *incoming* IPIP as it is not a
        commercially recognised protocol.  Some routers only allow
        TCP and UDP port forwarding, with no provision for any other
        protocol.  If you or your link partner have such a router,
        you may need to consider IPUDP instead.

SEE ALSO
        IP(1)          -- IP Routing / Configuration Commands.
        IPENCAP(9)     -- IPENCAP Protocol.
        IPROUTE.SYS(8) -- IP Routing / Configuration File.
        IPUDP(9)       -- IP-within-UDP Encapsulation.
        XROUTER.CFG(8) -- Main Configuration File.

IPIP(9)                     END OF DOCUMENT
