;*************************** Max Width *******************************
IPLINK(7)             XROUTER REFERENCE MANUAL               25/9/2023

NAME
        IPLINK -- Peer Address of a Link.

SYNOPSIS
        IPLINK=<ip_address_or_hostname>

DESCRIPTION
        IPLINK is a PORT configuration directive used in XROUTER.CFG,
        which is mandatory for AXIP and AXUDP ports. for other types
        of port it has no meaning, and is ignored.

        IPLINK specifies the IP address or hostname of an AXIP or
        AXUDP link partner.

        If the partner has a static IP address, it is more efficient
        to specify the IP address here, otherwise it may be necessary
        to use the hostname.

        A special case, "IPLINK=0.0.0.0" allows the PORT to be used
        in "Multiple-Links-Per-Port" mode, whereby one PORT supports
        several links. In this mode, formal links are specified using
        PEER commands, instead of the usual IPLINK/UDPREMOTE.

        The IPLINK address can be changed during run-time using the
        IPLINK *command*, but a run-time change to or from "0.0.0.0"
        is not allowed.

EXAMPLES
        IPLINK=62.51.67.21
        IPLINK=gb7pzt.dyndns.org

SEE ALSO
        AXIP(9)        -- AX25-over-IP Tunnelling.
        AXUDP(9)       -- AX25-over-UDP Tunnelling.
        IPLINK(1)      -- Display / Set Port IPLINK Address.
        PEER(7)        -- Specify AXIP / AXUDP Link Partner
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

IPLINK(7)                  END OF DOCUMENT
