IPLINK(1)             XROUTER REFERENCE MANUAL               25/9/2023

COMMAND
        IPLINK -- Display / Set Port IPLINK Address.

SYNOPSIS
        IPL[ink] <port> [ipaddress | hostname]

AVAILABILITY
        This command is sysop-only.

DESCRIPTION
        The IPLINK command allows the specified port's IPLINK address
        to be displayed and changed.

        IPLINK is the AXIP or AXUDP link partner's IP address or
        hostname.

        It is usually specified within a PORT configuration block in
        the XROUTER.CFG file, but since partner sysops sometimes
        change their IP address or hostname, this command allows it
        to be changed on the fly, without needing to take XRouter off
        line.

OPTIONS
        If a single numeric argument is supplied, and it is a valid
        port number, the current IPLINK value for that port, is
        displayed, along with the equivalent IP address.

        If two arguments are supplied, the first must specify a valid
        port number and the second specifies a new IPLINK address for 
        that port.

        If a hostname is specified, the IP address displayed in
        brackets may still show the old value until a frame is sent
        to, or received from the peer.

EXAMPLES
        IPLINK 16                - Display current IPLINK for port 16
        IPLINK 16 g8pzt.ath.cx   - Set port 16 IPLINK to g8pzt.ath.cx

SEE ALSO
        AXIP(9)        -- AX25-over-IP Tunnelling.
        AXUDP(9)       -- AX25-over-UDP Tunnelling.
        IPLINK(7)      -- Peer IP Address
        PORTS(6)       -- Ports in XRouter.
        XROUTER.CFG(8) -- Main Configuration File.

IPLINK(1)                       END OF DOCUMENT
